/*
 * The Web 4.0 ™ platform is supported by enterprise level subscription through Cerulean Circle GmbH
 *    Copyright (C) 2017  Marcel Donges (marcel@donges.it)
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 	{
 		license: "AGPL3.0",
 		href: "http://www.gnu.org/licenses/agpl-3.0.de.html"
 		coAuthors: [
 			"Igor",
 			"Philipp Bartels",
 			}
 	}
 */



/* global EmptyRelationship, User, CollapsiblePanel */
var ApplicationFrame = Namespace.declare("tla.EAM.layer3",
    class ApplicationFrame extends Interface {
        /*
        static get defaultImplementationClass() {
            return DefaultApplicationFrame;
        }
        */
        static get dependencies() {
            return this.defaultImplementationClass.dependencies;
        }

        static get weBeanUnitPaths() {
            return this.defaultImplementationClass.weBeanUnitPaths;
        }

        static get overwriteServerDescriptor() {
            return this.defaultImplementationClass.overwriteServerDescriptor;
        }

        static get eamLayer() {
            return 3;
        }

        static get WORKFLOW_SELECT() { return "actionId:protected:ApplicationFrame.startSelectWorkflow[Select]"; }
        static get WORKFLOW_ASSIGN() { return "actionId:protected:ApplicationFrame.assign[Choose this]:success"; }
        static get ACTION_CLEAR() { return "actionId:protected:ApplicationFrame.setEmpty[Remove]:success"; }

    }
);


var DefaultApplicationFrame = Namespace.declare("tla.EAM.layer2",
    class DefaultApplicationFrame extends UcpComponent {
        static get implements() {
            return [ApplicationFrame];
        }

        static get overwriteServerDescriptor() {
            return true;
        }

        static get dependencies() {
            return [
                "/EAMD.ucp/Components/com/twitter/Bootstrap/4.1.3/Bootstrap.component.xml"
            ];
        }

        static get weBeanUnitPaths() {
            return [
                "src/html/weBeans/ApplicationFrame.weBean.html",
                "src/html/weBeans/ApplicationFrameMinimalItemView.weBean.html",
                "src/html/weBeans/ApplicationFrameMinimalDetailsView.weBean.html"
            ];
        }

        static start() {
            UcpComponentSupport.importLink(this.IOR.basePath + "/src/less/" + this.name + ".less", "stylesheet/less", "text/css");
        }

        constructor() {
            super();
        }

        init() {
            super.init();

            const model = {
                itemViewModel: {
                    name: this.constructor.name,
                    description: "Basic Application Frame",
                    badge: "AppFrame" //"has to be copied on UcpView.init"
                },

                logosrc: "shift Logo",
                logourl: "#",
                relationship1: EmptyRelationship.of(User),
                collection1: [1, 2, 3, 4, 5],

                subComponent: undefined

            };
            this.model = model;
            this.model.autoUpdate = true;

            Thinglish.defineAlias(this.model, "itemViewModel.name");
            Thinglish.defineAlias(this.model, "itemViewModel.description");
            Thinglish.defineAlias(this.model, "itemViewModel.badge");
            //inherit superModel ... until ManagedProperties will suport nested models
            //Object.keys(super.model).forEach(k => Thinglish.defineAlias(model, "defaultViewModel." + k));

            this.actionIndex = Thinglish.createActionIndexOf(ApplicationFrame, this);

            return this;
        }


        get property1() {
                return this.ucpModel.value.property1;
        }
        set property1(newValue) {
                this.ucpModel.value.property1 = newValue;
        }


        get subComponent() {
            if (this.model && this.ucpModel.value.subComponent) {
                return this.ucpModel.value.subComponent;
            }
            const newComponent = new CollapsiblePanel().init();
            //configure subComponent
            newComponent.name = "new Subcomponent";
            this.model.subComponent = newComponent;

            return newComponent;
        }

        set subComponent(newComponent) {
            this.ucpModel.value.subComponent = newComponent;
        }

        /*
        onInitDetails(view) {
           console.info("ucpComponent onInitDetails",view.id,  ...arguments);
           this.details.model.heading = "Details initialized";

           console.info(`
           In the DefaultView WeBean ApplicationFrame.weBean.html a webean-property="details" ist declared on
                <bootstrap-collapsible-panel heading="Details" webean-property="details">

           this.details gives you access to the ucpView of that CollapsiblePanel
           this.detailsElement gives you access to  this.details.documentElement in the DOM          
           
           initalize any DOM listeners here.
           the method will be called after every new rendering
           `);
        }
        */

        onDomReady(view) {
            console.info("ucpComponent onDomReady", this.id, ...arguments);
            console.info("ucpComponent onDomReady - view:", this.id, view.id, view.documentElement);
            console.info(`
           the view is fully rendered and available in the DOM.

           initalize any DOM listeners here.
           the method will be called after every new rendering
           `);
        }


        /*
        loadWeBean() {
            if (Thinglish.lookupInObject(Relationship, "type.ucpComponentDescriptor.webBeanUnits"))
                return Relationship.type.ucpComponentDescriptor.webBeanUnits.find(u => u.model.name.startsWith(Relationship.name)).weBean;

            return null;
        }
        */

        updateView(view, updateObject) {
            console.info("ucpComponent updateView", this.id, ...arguments);

            console.info(`
           notifies you which view has to be rerendered.
           calling this.update() will force a complete rerendering.

           this implies loosing all DOM listeners. after rerendering onDomReady(view) will be called again to reinatialize DOM listeners

           calling tis.documentElement does the first rendering.
           the framework tries to postpone this step to the last possible point so that you can initialize the model first and 
           do not have to rerender many times. the last possible point to render, is if the element will be appended to to an element
           that is already in the DOM. The UcpView method checkTargetElement finds out if an element isInDom and ataches the boolean to the element.

           alternatively you can check the updateObject to see what in the model did change
           and update the dom manually here on view.documentElement or view.subViewElement

           view.subView gives you access to ucpViews declared as webeanProperties in the weBean
           `, this.id, ...arguments);

            if (!updateObject) {
                return;
            }
            Object.keys(updateObject).forEach(
                member => {
                    switch (member) {
                        case "attribute1":
                            //update something for attribute1
                            break;
                        case "property1":
                            //update something for property1
                            break;
                        default:
                            //update something in any case
                    }
                }
            );
        }

        handleSelection(event, item) {
            console.info(this.constructor.name, "selected", item.ucpComponent);
            Action.do(DetailsView.ACTION_SHOW, this);
            //Action.do(Workflow.ACTION_SELECT, item);
        }

        /*
            createOverView() {
                return new ApplicationFrameMinimalItemView();
            }
            createDetailsView() {
                return new ApplicationFrameMinimalDetailsView();
            }
        */
        startSelectWorkflow() {
            console.info(this.constructor.name, "startSelectWorkflow");
        }

        assign() {
            console.info(this.constructor.name, "assign");
        }

        setEmpty() {
            console.info(this.constructor.name, "setEmpty");
        }
    }
);

var ApplicationFrameMinimalItemView = Namespace.declare("tla.EAM.layer5",
    class ApplicationFrameMinimalItemView extends UcpView {
        static get implements() { return [ItemView]; }

        init(ucpComponent) {
            super.init(ucpComponent);
            this.badge = "some Value";
            return this;
        }

        update(updateObject) {
            console.info("ucpView update", this.id, ...arguments);
            if (!updateObject) {
                return;
            }
            Object.keys(updateObject).forEach(
                member => {
                    switch (member) {
                        case "badge":
                            //update something for badge
                            break;
                        case "attribute1":
                            //update something for attribute1
                            break;
                        default:
                            //update something in any case
                    }
                }
            );
        }

    }
);


var ApplicationFrameMinimalDetailsView = Namespace.declare("tla.EAM.layer5",
    class ApplicationFrameMinimalDetailsView extends UcpView {
        static get implements() { return [DetailsView]; }

        init(ucpComponent) {
            super.init(ucpComponent);

            return this;
        }

        update(updateObject) {
            console.info("ucpView update", this.id, ...arguments);
        }

        onInitDetails() {
            console.info("ucpView onInitDetails", this.id, ...arguments);
            this.details.model.heading += " also from DetailsView";

        }

    }
);