/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;

public class NamedLabelScanStoreSelectionStrategy
implements DependencyResolver.SelectionStrategy {
    private final String specificallyConfigured;

    public NamedLabelScanStoreSelectionStrategy(Config config) {
        this.specificallyConfigured = config.get(GraphDatabaseSettings.label_index);
        Objects.requireNonNull(this.specificallyConfigured);
    }

    public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
        if (!type.equals(LabelScanStoreProvider.class)) {
            throw new IllegalArgumentException("Was expecting " + LabelScanStoreProvider.class);
        }
        String name = this.specificallyConfigured;
        if (GraphDatabaseSettings.LabelIndex.AUTO.name().equalsIgnoreCase(name)) {
            T present = NamedLabelScanStoreSelectionStrategy.selectSingleProviderWhichHasStore(candidates);
            if (present != null) {
                return present;
            }
            name = GraphDatabaseSettings.LabelIndex.valueOf(GraphDatabaseSettings.label_index.getDefaultValue()).name();
        }
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (T candidate : candidates) {
            LabelScanStoreProvider provider = (LabelScanStoreProvider)((Object)candidate);
            String candidateName = provider.getName();
            candidateNames.add(candidateName);
            if (!name.equalsIgnoreCase(candidateName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Configured label index '" + this.specificallyConfigured + "', but couldn't find it among candidates " + candidateNames);
    }

    private static <T> T selectSingleProviderWhichHasStore(Iterable<T> candidates) {
        IOException exception = null;
        T present = null;
        for (T candidate : candidates) {
            LabelScanStoreProvider provider = (LabelScanStoreProvider)((Object)candidate);
            try {
                if (!provider.hasStore()) continue;
                if (present != null) {
                    throw new IllegalArgumentException("There are multiple present label indexes, at least " + present + " and " + (Object)((Object)provider) + ". Please select a specific " + GraphDatabaseSettings.label_index.name() + " instead");
                }
                present = candidate;
            }
            catch (IOException e) {
                exception = (IOException)Exceptions.combine(exception, (Throwable)e);
            }
        }
        if (present != null) {
            return present;
        }
        if (exception != null) {
            throw new IllegalArgumentException(exception);
        }
        return null;
    }
}

