/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.impl.store.TransactionId;

public class HighestTransactionId {
    private final AtomicReference<TransactionId> highest = new AtomicReference();

    public HighestTransactionId(long initialTransactionId, long initialChecksum, long commitTimestamp) {
        this.set(initialTransactionId, initialChecksum, commitTimestamp);
    }

    public boolean offer(long transactionId, long checksum, long commitTimestamp) {
        TransactionId high = this.highest.get();
        if (transactionId < high.transactionId()) {
            return false;
        }
        TransactionId update = new TransactionId(transactionId, checksum, commitTimestamp);
        while (!this.highest.compareAndSet(high, update)) {
            high = this.highest.get();
            if (high.transactionId() < transactionId) continue;
            return false;
        }
        return true;
    }

    public void set(long transactionId, long checksum, long commitTimestamp) {
        this.highest.set(new TransactionId(transactionId, checksum, commitTimestamp));
    }

    public TransactionId get() {
        return this.highest.get();
    }
}

