/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.mqtt.MQTTContext;
import org.structr.mqtt.MQTTInfo;

public class MQTTClientConnection
implements MqttCallback {
    private MemoryPersistence persistence = new MemoryPersistence();
    private MqttConnectOptions connOpts;
    private MqttClient client;
    private MQTTInfo info;
    private static final Logger logger = LoggerFactory.getLogger((String)MQTTClientConnection.class.getName());

    public MQTTClientConnection(MQTTInfo mQTTInfo) throws MqttException {
        this.info = mQTTInfo;
        String string = mQTTInfo.getProtocol() + mQTTInfo.getUrl() + ":" + mQTTInfo.getPort();
        this.client = new MqttClient(string, mQTTInfo.getUuid(), (MqttClientPersistence)this.persistence);
        this.client.setCallback((MqttCallback)this);
        this.connOpts = new MqttConnectOptions();
        this.connOpts.setCleanSession(true);
    }

    public void connect() throws FrameworkException {
        try {
            if (!this.client.isConnected()) {
                this.client.connect(this.connOpts);
                this.info.connectionStatusCallback(true);
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Could not connect to MQTT broker.");
        }
    }

    public void disconnect() throws FrameworkException {
        try {
            if (this.client.isConnected()) {
                this.client.disconnect();
                this.info.connectionStatusCallback(false);
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Error while disconnecting from MQTT broker.");
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void sendMessage(String string, String string2) throws FrameworkException {
        try {
            if (this.client.isConnected()) {
                MqttMessage mqttMessage = new MqttMessage(string2.getBytes());
                mqttMessage.setQos(this.info.getQoS());
                this.client.publish(string, mqttMessage);
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Error while sending message.");
        }
    }

    public void subscribeTopic(String string) throws FrameworkException {
        try {
            if (this.client.isConnected()) {
                this.client.subscribe(string, this.info.getQoS());
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Error while subscribing to topic.");
        }
    }

    public void unsubscribeTopic(String string) throws FrameworkException {
        try {
            if (this.client.isConnected()) {
                this.client.unsubscribe(string);
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Error while unsubscribing from topic.");
        }
    }

    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        Thread thread = new Thread(new CallbackWorker(this.info, string, mqttMessage.toString()));
        thread.start();
    }

    public void connectionLost(Throwable throwable) {
        try {
            this.info.connectionStatusCallback(false);
            this.connect();
            MQTTContext.subscribeAllTopics(this.info);
        }
        catch (FrameworkException frameworkException) {
            try {
                logger.warn("Removing faulty connection from MQTTContext.");
                MQTTContext.disconnect(this.info);
            }
            catch (FrameworkException frameworkException2) {
                logger.error("Could not remove connection from MQTTContext.");
            }
            logger.error("Could not reconnect to MQTT broker.");
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    private class CallbackWorker
    implements Runnable {
        private final MQTTInfo info;
        private final String topic;
        private final String message;

        public CallbackWorker(MQTTInfo mQTTInfo, String string, String string2) {
            this.info = mQTTInfo;
            this.topic = string;
            this.message = string2;
        }

        @Override
        public void run() {
            this.info.messageCallback(this.topic, this.message);
        }
    }
}

