/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt.entity;

import java.util.HashMap;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.Tx;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.mqtt.MQTTClientConnection;
import org.structr.mqtt.MQTTContext;
import org.structr.mqtt.MQTTInfo;
import org.structr.mqtt.entity.MQTTSubscriber;
import org.structr.mqtt.entity.relation.MQTTClientHAS_SUBSCRIBERMQTTSubscriber;
import org.structr.rest.RestMethodResult;
import org.structr.schema.SchemaService;

public class MQTTClient
extends AbstractNode
implements MQTTInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)MQTTClient.class.getName());
    public static final Property<List<MQTTSubscriber>> subscribers = new EndNodes("subscribers", MQTTClientHAS_SUBSCRIBERMQTTSubscriber.class);
    public static final Property<String> protocol = new StringProperty("protocol").defaultValue((Object)"tcp://");
    public static final Property<String> url = new StringProperty("url");
    public static final Property<Integer> port = new IntProperty("port");
    public static final Property<Integer> qos = new IntProperty("qos").defaultValue((Object)0);
    public static final Property<Boolean> isEnabled = new BooleanProperty("isEnabled");
    public static final Property<Boolean> isConnected = new BooleanProperty("isConnected");
    public static final View defaultView = new View(MQTTClient.class, "public", new Property[]{id, type, subscribers, protocol, url, port, qos, isEnabled, isConnected});
    public static final View uiView = new View(MQTTClient.class, "ui", new Property[]{id, name, owner, type, createdBy, deleted, hidden, createdDate, lastModifiedDate, visibleToPublicUsers, visibleToAuthenticatedUsers, visibilityStartDate, visibilityEndDate, subscribers, protocol, url, port, qos, isEnabled, isConnected});

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            MQTTContext.connect(this);
        }
        return super.onCreation(securityContext, errorBuffer);
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (modificationQueue.isPropertyModified((GraphObject)this, protocol) || modificationQueue.isPropertyModified((GraphObject)this, url) || modificationQueue.isPropertyModified((GraphObject)this, port)) {
            MQTTContext.disconnect(this);
        }
        if (modificationQueue.isPropertyModified((GraphObject)this, isEnabled) || modificationQueue.isPropertyModified((GraphObject)this, protocol) || modificationQueue.isPropertyModified((GraphObject)this, url) || modificationQueue.isPropertyModified((GraphObject)this, port)) {
            MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(this.getUuid());
            boolean bl = (Boolean)this.getProperty((PropertyKey)isEnabled);
            if (!bl) {
                if (mQTTClientConnection != null && mQTTClientConnection.isConnected()) {
                    MQTTContext.disconnect(this);
                    this.setProperties(securityContext, new PropertyMap(isConnected, (Object)false));
                }
            } else {
                if (mQTTClientConnection == null || !mQTTClientConnection.isConnected()) {
                    MQTTContext.connect(this);
                    MQTTContext.subscribeAllTopics(this);
                }
                if ((mQTTClientConnection = MQTTContext.getClientForId(this.getUuid())) != null) {
                    if (mQTTClientConnection.isConnected()) {
                        this.setProperties(securityContext, new PropertyMap(isConnected, (Object)true));
                    } else {
                        this.setProperties(securityContext, new PropertyMap(isConnected, (Object)false));
                    }
                }
            }
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap propertyMap) throws FrameworkException {
        MQTTClientConnection mQTTClientConnection;
        String string = (String)propertyMap.get((PropertyKey)id);
        if (string != null && (mQTTClientConnection = MQTTContext.getClientForId(string)) != null) {
            mQTTClientConnection.disconnect();
        }
        return super.onDeletion(securityContext, errorBuffer, propertyMap);
    }

    @Override
    public String getProtocol() {
        return (String)this.getProperty((PropertyKey)protocol);
    }

    @Override
    public String getUrl() {
        return (String)this.getProperty((PropertyKey)url);
    }

    @Override
    public int getPort() {
        return (Integer)this.getProperty((PropertyKey)port);
    }

    @Override
    public int getQoS() {
        return (Integer)this.getProperty((PropertyKey)qos);
    }

    @Override
    public void messageCallback(String string, String string2) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            List list = (List)this.getProperty((PropertyKey)subscribers);
            for (MQTTSubscriber mQTTSubscriber : list) {
                String string3 = (String)mQTTSubscriber.getProperty((PropertyKey)MQTTSubscriber.topic);
                if (StringUtils.isEmpty((String)string3) || !string3.equals(string)) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("topic", string);
                hashMap.put("message", string2);
                try {
                    mQTTSubscriber.invokeMethod("onMessage", hashMap, false);
                }
                catch (FrameworkException frameworkException) {
                    logger.warn("Error while calling onMessage callback for MQTT subscriber.");
                }
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.error("Could not handle message callback for MQTT subscription.");
        }
    }

    @Override
    public void connectionStatusCallback(boolean bl) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            this.setProperties(this.securityContext, new PropertyMap(isConnected, (Object)bl));
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("Error in connection status callback for MQTTClient.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getTopics() {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            List list = (List)this.getProperty((PropertyKey)subscribers);
            String[] stringArray2 = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray2[i] = (String)((MQTTSubscriber)((Object)list.get(i))).getProperty((PropertyKey)MQTTSubscriber.topic);
            }
            String[] stringArray = stringArray2;
            return stringArray;
        }
        catch (FrameworkException frameworkException) {
            logger.error("Couldn't retrieve client topics for MQTT subscription.");
            return null;
        }
    }

    @Export
    public RestMethodResult sendMessage(String string, String string2) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(this.getUuid());
            if (mQTTClientConnection.isConnected()) {
                mQTTClientConnection.sendMessage(string, string2);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult subscribeTopic(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(this.getUuid());
            if (mQTTClientConnection.isConnected()) {
                mQTTClientConnection.subscribeTopic(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult unsubscribeTopic(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(this.getUuid());
            if (mQTTClientConnection.isConnected()) {
                mQTTClientConnection.unsubscribeTopic(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"MQTTClient", (String)MQTTClient.class.getName());
    }
}

