/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt.entity;

import java.util.HashMap;
import org.apache.cxf.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.mqtt.entity.MQTTClient;
import org.structr.mqtt.entity.relation.MQTTClientHAS_SUBSCRIBERMQTTSubscriber;
import org.structr.rest.RestMethodResult;
import org.structr.schema.SchemaService;
import org.structr.schema.action.ActionContext;

public class MQTTSubscriber
extends AbstractNode {
    private static final Logger logger = LoggerFactory.getLogger((String)MQTTSubscriber.class.getName());
    public static final Property<MQTTClient> client = new StartNode("client", MQTTClientHAS_SUBSCRIBERMQTTSubscriber.class);
    public static final Property<String> topic = new StringProperty("topic");
    public static final Property<String> source = new StringProperty("source");
    public static final View defaultView = new View(MQTTClient.class, "public", new Property[]{id, type, client, topic, source});
    public static final View uiView = new View(MQTTClient.class, "ui", new Property[]{id, name, owner, type, createdBy, deleted, hidden, createdDate, lastModifiedDate, visibleToPublicUsers, visibleToAuthenticatedUsers, visibilityStartDate, visibilityEndDate, client, topic, source});

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (!StringUtils.isEmpty((String)((String)this.getProperty((PropertyKey)topic))) && this.getProperty((PropertyKey)client) != null && ((Boolean)((MQTTClient)this.getProperty((PropertyKey)client)).getProperty((PropertyKey)MQTTClient.isConnected)).booleanValue()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("topic", this.getProperty((PropertyKey)topic));
            ((MQTTClient)this.getProperty((PropertyKey)client)).invokeMethod("subscribeTopic", hashMap, false);
        }
        return super.onCreation(securityContext, errorBuffer);
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (!StringUtils.isEmpty((String)((String)this.getProperty((PropertyKey)topic))) && this.getProperty((PropertyKey)client) != null && ((Boolean)((MQTTClient)this.getProperty((PropertyKey)client)).getProperty((PropertyKey)MQTTClient.isConnected)).booleanValue() && modificationQueue.isPropertyModified((GraphObject)this, topic)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("topic", this.getProperty((PropertyKey)topic));
            ((MQTTClient)this.getProperty((PropertyKey)client)).invokeMethod("subscribeTopic", hashMap, false);
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    @Export
    public RestMethodResult onMessage(String string, String string2) throws FrameworkException {
        if (!StringUtils.isEmpty((String)((String)this.getProperty((PropertyKey)source)))) {
            String string3 = "${" + (String)this.getProperty((PropertyKey)source) + "}";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("topic", string);
            hashMap.put("message", string2);
            ActionContext actionContext = new ActionContext(this.securityContext, hashMap);
            Scripting.replaceVariables((ActionContext)actionContext, (GraphObject)this, (Object)string3);
        }
        return new RestMethodResult(200);
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"MQTTSubscriber", (String)MQTTSubscriber.class.getName());
    }
}

