/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt.function;

import org.structr.common.error.FrameworkException;
import org.structr.mqtt.entity.MQTTClient;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MQTTSubscribeTopicFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MQTTSUBSCRIBE = "Usage: ${mqtt_subscribe(client, topic)}. Example ${mqtt_subscribe(client, 'myTopic')}";
    public static final String ERROR_MESSAGE_MQTTSUBSCRIBE_JS = "Usage: ${{Structr.mqtt_subscribe(client, topic)}}. Example ${{Structr.mqtt_subscribe(client, topic)}}";

    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (objectArray != null && objectArray.length == 2 && objectArray[0] != null && objectArray[1] != null) {
            MQTTClient mQTTClient = null;
            if (objectArray[0] instanceof MQTTClient) {
                mQTTClient = (MQTTClient)objectArray[0];
            }
            if (mQTTClient == null) {
                this.logParameterError(object, objectArray, actionContext.isJavaScriptContext());
                return "";
            }
            mQTTClient.subscribeTopic(objectArray[1].toString());
        } else {
            this.logParameterError(object, objectArray, actionContext.isJavaScriptContext());
        }
        return "";
    }

    public String usage(boolean bl) {
        return bl ? ERROR_MESSAGE_MQTTSUBSCRIBE_JS : ERROR_MESSAGE_MQTTSUBSCRIBE;
    }

    public String shortDescription() {
        return "Subscribes given topic on given mqtt client.";
    }

    public String getName() {
        return "mqtt_subscribe";
    }
}

