/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.data.TimeoutException;
import org.structr.net.data.time.PseudoTemporalEnvironment;
import org.structr.net.peer.Peer;
import org.structr.net.protocol.AbstractMessage;
import org.structr.net.protocol.Ack;
import org.structr.net.protocol.BeginTx;
import org.structr.net.protocol.Callback;
import org.structr.net.protocol.Commit;
import org.structr.net.protocol.Get;
import org.structr.net.protocol.Set;
import org.structr.net.protocol.Value;
import org.structr.net.repository.RepositoryObject;

public class RemoteTransaction
implements Callback,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger((String)RemoteTransaction.class.getName());
    private PseudoTemporalEnvironment pte = null;
    private AbstractMessage message = null;
    private String transactionOwner = null;
    private final Object lock = new Object();
    private String transactionId = null;
    private boolean hasTimeout = false;
    private long timeoutValue = 5000L;
    private Peer peer = null;

    public RemoteTransaction(Peer peer) {
        this.pte = peer.getPseudoTemporalEnvironment().transaction();
        this.peer = peer;
    }

    public Object getProperty(RepositoryObject repositoryObject, String string) throws TimeoutException {
        Get get = new Get(this.peer.getUuid(), repositoryObject, this.pte.current(), this.transactionId, string);
        this.peer.registerCallback(get.getId(), this);
        this.peer.broadcast(get);
        this.waitForCallback(get.getId(), this.timeoutValue);
        if (this.message != null && this.message instanceof Value) {
            Value value = (Value)this.message;
            return value.getValue();
        }
        return null;
    }

    public void setProperty(RepositoryObject repositoryObject, String string, Object object) throws TimeoutException {
        this.peer.log("Set(", repositoryObject.getUuid(), ", ", string, ", ", object, ")");
        Set set = new Set(this.peer.getUuid(), repositoryObject, this.pte.next(), this.transactionId, string, object);
        this.peer.registerCallback(set.getId(), this);
        this.peer.broadcast(set);
        this.waitForCallback(set.getId(), this.timeoutValue);
    }

    public void begin(RepositoryObject repositoryObject) throws TimeoutException {
        this.transactionOwner = repositoryObject.getDeviceId();
        this.peer.log("BeginTx()");
        BeginTx beginTx = new BeginTx(this.peer.getUuid(), this.transactionOwner, this.timeoutValue);
        this.peer.registerCallback(beginTx.getId(), this);
        this.peer.broadcast(beginTx);
        this.waitForCallback(beginTx.getId(), this.timeoutValue);
        if (this.message != null && this.message instanceof Ack) {
            Ack ack = (Ack)this.message;
            this.transactionId = ack.getData();
        }
    }

    public void commit() throws TimeoutException {
        this.peer.log("Commit(", this.transactionId, ")");
        Commit commit = new Commit(this.peer.getUuid(), this.transactionOwner, this.transactionId);
        this.peer.registerCallback(commit.getId(), this);
        this.peer.broadcast(commit);
        this.waitForCallback(commit.getId(), this.timeoutValue);
    }

    @Override
    public void close() throws Exception {
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(AbstractMessage abstractMessage) {
        Object object = this.lock;
        synchronized (object) {
            this.hasTimeout = false;
            this.message = abstractMessage;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCallback(String string, long l) throws TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            this.message = null;
            this.hasTimeout = true;
            try {
                this.lock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                logger.warn("", (Throwable)interruptedException);
            }
            if (this.hasTimeout) {
                this.peer.unregisterCallback(string);
                throw new TimeoutException();
            }
        }
    }
}

