/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.peer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.PeerListener;
import org.structr.net.data.RemoteTransaction;
import org.structr.net.data.TimeoutException;
import org.structr.net.data.time.Clock;
import org.structr.net.data.time.PseudoTemporalEnvironment;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.data.time.ToplevelTemporalEnvironment;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.AbstractMessage;
import org.structr.net.protocol.Callback;
import org.structr.net.protocol.Delete;
import org.structr.net.protocol.Discovery;
import org.structr.net.protocol.Envelope;
import org.structr.net.protocol.Inventory;
import org.structr.net.protocol.Update;
import org.structr.net.repository.DefaultRepositoryObject;
import org.structr.net.repository.InternalChangeListener;
import org.structr.net.repository.Repository;
import org.structr.net.repository.RepositoryObject;

public final class Peer
implements Runnable,
Clock,
InternalChangeListener {
    public static final int START_PORT = 5757;
    private static final Logger logger = LoggerFactory.getLogger((String)Peer.class.getName());
    private final Queue<Envelope> outputQueue = new ConcurrentLinkedQueue<Envelope>();
    private final Queue<Envelope> inputQueue = new ConcurrentLinkedQueue<Envelope>();
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<String, PeerInfo> peers = new ConcurrentHashMap<String, PeerInfo>();
    private final Map<String, Callback> callbacks = new ConcurrentHashMap<String, Callback>();
    private final Charset utf8 = Charset.forName("utf-8");
    private final List<PeerListener> listeners = new LinkedList<PeerListener>();
    private Map<String, Object> data = new HashMap<String, Object>();
    private KeyPair keyPair = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private ToplevelTemporalEnvironment pte = new ToplevelTemporalEnvironment(this);
    private Repository repository = null;
    private boolean initialized = false;
    private String initialPeer = null;
    private String bindAddress = null;
    private DatagramSocket serverSocket = null;
    private long timeOffset = 0L;
    private int localPort = 5757;
    private int sent = 0;
    private int received = 0;
    private boolean running = true;
    private boolean verbose = false;
    private int discoveryInterval = 1000;
    private int discoveryIntervalStep = 1000;
    private int finalDiscoveryInterval = 6000;
    private int hightestTxNumber = 0;

    public Peer(KeyPair keyPair, Repository repository) {
        this(keyPair, repository, "0.0.0.0");
    }

    public Peer(KeyPair keyPair, Repository repository, String string) {
        this(keyPair, repository, string, "255.255.255.255");
    }

    public Peer(KeyPair keyPair, Repository repository, String string, String string2) {
        this.keyPair = keyPair;
        this.bindAddress = string;
        this.initialPeer = string2;
        this.repository = repository;
        repository.addInternalChangeListener(this);
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        while (this.running) {
            try {
                Object object;
                Object object2;
                l = System.currentTimeMillis();
                while (!this.inputQueue.isEmpty() && l < l3 + (long)this.discoveryInterval && l < l2 + (long)this.discoveryIntervalStep) {
                    l = System.currentTimeMillis();
                    object2 = this.inputQueue.poll();
                    if (object2 == null) continue;
                    object = ((Envelope)object2).getMessage();
                    this.onMessage((AbstractMessage)object);
                    String string = ((AbstractMessage)object).getId() + "-ack";
                    if (this.getData(string) != null) continue;
                    ((AbstractMessage)object).onMessage(this, ((Envelope)object2).getPeer());
                    this.broadcast((AbstractMessage)object);
                    this.setData(string, true);
                }
                if (l > l3 + (long)this.discoveryInterval) {
                    l3 = l;
                    this.send(new PeerInfo(this.getPublicKey(), this.repository.getUuid(), this.initialPeer, 5757), new Discovery(this.getContentHash()));
                    if (this.discoveryInterval < this.finalDiscoveryInterval) {
                        this.discoveryInterval += this.discoveryIntervalStep;
                    }
                }
                if (l > l2 + (long)this.discoveryIntervalStep) {
                    l2 = l;
                    object2 = this.peers.values().iterator();
                    while (object2.hasNext()) {
                        object = (PeerInfo)object2.next();
                        long l4 = ((PeerInfo)object).getLastSeen() + (long)this.finalDiscoveryInterval + (long)(this.discoveryIntervalStep * 2);
                        if (l <= l4) continue;
                        this.onRemovePeer((PeerInfo)object);
                        object2.remove();
                    }
                }
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        this.executorService.shutdownNow();
    }

    public void start() {
        if (!this.initialized) {
            throw new IllegalStateException("Peer not initialized, did you call initializeServer?!");
        }
        try {
            this.executorService.submit(new InputHandler());
            this.executorService.submit(new OutputHandler());
            this.executorService.submit(this);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            logger.warn("Unable to start peer, aborting.");
            this.executorService.shutdown();
        }
    }

    public void initializeServer() {
        boolean bl = false;
        while (!bl && this.localPort < 5767) {
            try {
                this.serverSocket = new DatagramSocket(this.localPort, InetAddress.getByName(this.bindAddress));
                bl = true;
            }
            catch (IOException iOException) {
                ++this.localPort;
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        if (!bl) {
            System.out.println("Unable to bind to " + this.bindAddress + ", aborting.");
            this.running = false;
        } else {
            this.initialized = true;
        }
    }

    public void stop() {
        this.running = false;
        this.serverSocket.close();
    }

    public String getUuid() {
        return this.repository.getUuid();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public int getTransactionNumber() {
        return this.hightestTxNumber;
    }

    public void setTransactionNumber(int n) {
        this.hightestTxNumber = n;
    }

    public PseudoTemporalEnvironment getPseudoTemporalEnvironment() {
        return this.pte;
    }

    public void send(PeerInfo peerInfo, AbstractMessage abstractMessage) {
        this.outputQueue.add(new Envelope(peerInfo, abstractMessage));
    }

    public void onPeerDiscovery(PeerInfo peerInfo, byte[] byArray) {
        if (peerInfo != null && !peerInfo.getUuid().equals(this.getUuid())) {
            boolean bl;
            boolean bl2 = this.addPeer(peerInfo);
            byte[] byArray2 = this.getContentHash();
            boolean bl3 = bl = !Arrays.equals(byArray, byArray2);
            if (bl2 || bl) {
                if (bl2) {
                    System.out.println("Peer is new, sending inventory..");
                }
                if (bl) {
                    System.out.println("Peer has different content hash, sending inventory..");
                    System.out.println(this.printHash(byArray) + " / " + this.printHash(byArray2));
                }
                for (RepositoryObject repositoryObject : this.repository.getObjects()) {
                    this.log("Inventory(", repositoryObject.getUuid(), ", ", repositoryObject.getUserId(), ")");
                    this.send(peerInfo, new Inventory(this.repository.getUuid(), repositoryObject.getUuid(), repositoryObject.getDeviceId(), repositoryObject.getLastModificationTime()));
                }
            }
        }
    }

    public Collection<PeerInfo> getPeers() {
        return this.peers.values();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addListener(PeerListener peerListener) {
        this.listeners.add(peerListener);
    }

    public void removeListener(PeerListener peerListener) {
        this.listeners.remove(peerListener);
    }

    public synchronized void printInfo() {
        System.out.println("#########################################");
        System.out.println("Peer " + this.serverSocket.getLocalAddress() + ":" + this.localPort);
        System.out.println("UUID: " + this.getUuid());
        System.out.println("Time offset: " + this.timeOffset);
        System.out.println(this.received + " messages received, " + this.sent + " messages sent");
        System.out.println(this.peers.size() + " peers");
        for (PeerInfo object : this.peers.values()) {
            System.out.println("    " + object);
        }
        for (RepositoryObject repositoryObject : this.repository.getObjects()) {
            System.out.println("        ##### " + repositoryObject.getUuid());
            System.out.println("        " + repositoryObject.getType() + "(" + repositoryObject.getUserId() + "): " + repositoryObject.getProperties(this.pte.next()));
            ((DefaultRepositoryObject)repositoryObject).printHistory();
        }
        System.out.println(this.outputQueue);
        System.out.flush();
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void log(Object ... objectArray) {
        if (!this.verbose) {
            return;
        }
        for (Object object : objectArray) {
            System.out.print(object);
        }
        System.out.println();
    }

    public Object getData(String string) {
        return this.data.get(string);
    }

    public void setData(String string, Object object) {
        this.data.put(string, object);
    }

    public void broadcast(AbstractMessage abstractMessage) {
        this.inputQueue.add(new Envelope(new PeerInfo(this.getPublicKey(), this.repository.getUuid(), this.bindAddress, this.localPort), abstractMessage));
        for (PeerInfo peerInfo : this.getPeers()) {
            this.send(peerInfo, abstractMessage);
        }
    }

    public void set(String string, String string2, Object object) {
        RepositoryObject repositoryObject = this.repository.getObject(string);
        if (repositoryObject != null) {
            try (RemoteTransaction remoteTransaction = this.beginTx(repositoryObject);){
                remoteTransaction.setProperty(repositoryObject, string2, object);
                remoteTransaction.commit();
            }
            catch (Exception exception) {
                System.out.println("Failed");
            }
        } else {
            System.out.println("No such object " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String string, String string2) {
        RepositoryObject repositoryObject = this.repository.getObject(string);
        if (repositoryObject == null) {
            System.out.println("No such object " + string);
            return null;
        }
        try (RemoteTransaction remoteTransaction = this.beginTx(repositoryObject);){
            Object object = remoteTransaction.getProperty(repositoryObject, string2);
            return object;
        }
        catch (Exception exception) {
            System.out.println("Failed");
            return null;
        }
    }

    public RemoteTransaction beginTx(RepositoryObject repositoryObject) throws TimeoutException {
        RemoteTransaction remoteTransaction = new RemoteTransaction(this);
        remoteTransaction.begin(repositoryObject);
        return remoteTransaction;
    }

    public void registerCallback(String string, Callback callback) {
        this.callbacks.put(string, callback);
    }

    public void unregisterCallback(String string) {
        this.callbacks.remove(string);
    }

    public void callback(String string, AbstractMessage abstractMessage) {
        Callback callback = this.callbacks.get(string);
        if (callback != null) {
            callback.callback(abstractMessage);
            this.callbacks.remove(string);
        }
    }

    public long getCoordinatedTime() {
        return System.currentTimeMillis() + this.timeOffset;
    }

    public boolean knowsPeer(String string) {
        return this.peers.containsKey(string);
    }

    public byte[] getContentHash() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.warn("", (Throwable)noSuchAlgorithmException);
        }
        if (messageDigest != null) {
            long l = System.currentTimeMillis();
            LinkedList<RepositoryObject> linkedList = new LinkedList<RepositoryObject>(this.repository.getObjects());
            Collections.sort(linkedList, new UuidComparator());
            for (RepositoryObject repositoryObject : linkedList) {
                String string = repositoryObject.getUuid();
                String string2 = repositoryObject.getType();
                String string3 = repositoryObject.getLastModificationTime().toString();
                messageDigest.update(string.getBytes(this.utf8));
                messageDigest.update(string2.getBytes(this.utf8));
                messageDigest.update(string3.getBytes(this.utf8));
            }
            long l2 = System.currentTimeMillis();
            if (l2 - l > 100L) {
                System.out.println("Creation of content hash took " + (System.currentTimeMillis() - l) + " ms!");
            }
            return messageDigest.digest();
        }
        System.out.println("Cannot create hash value, algorithms not available.");
        return new byte[0];
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public long getTime() {
        return this.getCoordinatedTime();
    }

    public void onMessage(AbstractMessage abstractMessage) {
        for (PeerListener peerListener : this.listeners) {
            peerListener.onMessage(abstractMessage);
        }
    }

    public void onAddPeer(PeerInfo peerInfo) {
        for (PeerListener peerListener : this.listeners) {
            peerListener.onAddPeer(peerInfo);
        }
    }

    public void onRemovePeer(PeerInfo peerInfo) {
        for (PeerListener peerListener : this.listeners) {
            peerListener.onRemovePeer(peerInfo);
        }
    }

    private synchronized boolean addPeer(PeerInfo peerInfo) {
        String string = peerInfo.getUuid();
        if (!this.peers.containsKey(string)) {
            this.peers.put(string, peerInfo);
            peerInfo.setLastSeen(System.currentTimeMillis());
            this.onAddPeer(peerInfo);
            return true;
        }
        return false;
    }

    private synchronized void updatePeer(String string, long l) {
        PeerInfo peerInfo = this.peers.get(string);
        if (peerInfo != null) {
            peerInfo.setLastSeen(System.currentTimeMillis());
            peerInfo.setLatency(l);
        }
    }

    @Override
    public void onObjectCreation(RepositoryObject repositoryObject, Map<String, Object> map) {
        this.log("Create(", repositoryObject.getUuid(), ")");
        this.broadcast(new Update(this.repository.getUuid(), repositoryObject.getUuid(), repositoryObject.getType(), repositoryObject.getUserId(), repositoryObject.getCreationTime(), repositoryObject.getLastModificationTime(), map));
    }

    @Override
    public void onObjectModification(RepositoryObject repositoryObject, Map<String, Object> map) {
        this.log("Update(", repositoryObject.getUuid(), ")");
        this.broadcast(new Update(this.repository.getUuid(), repositoryObject.getUuid(), repositoryObject.getType(), repositoryObject.getUserId(), repositoryObject.getCreationTime(), repositoryObject.getLastModificationTime(), map));
    }

    @Override
    public void onObjectDeletion(String string) {
        this.log("Delete(", string, ")");
        this.broadcast(new Delete(this.repository.getUuid(), string, PseudoTime.now(this)));
    }

    private String printHash(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString();
    }

    private class UuidComparator
    implements Comparator<RepositoryObject> {
        private UuidComparator() {
        }

        @Override
        public int compare(RepositoryObject repositoryObject, RepositoryObject repositoryObject2) {
            return repositoryObject.getUuid().compareTo(repositoryObject2.getUuid());
        }
    }

    private class OutputHandler
    implements Runnable {
        private OutputHandler() {
        }

        @Override
        public void run() {
            while (Peer.this.running) {
                try {
                    while (!Peer.this.outputQueue.isEmpty()) {
                        Envelope envelope = (Envelope)Peer.this.outputQueue.poll();
                        if (envelope == null) continue;
                        AbstractMessage abstractMessage = envelope.getMessage();
                        PeerInfo peerInfo = envelope.getPeer();
                        abstractMessage.setSenderTimestamp(System.currentTimeMillis() + Peer.this.timeOffset);
                        abstractMessage.onSend(Peer.this);
                        Peer.this.serverSocket.send(AbstractMessage.forSending(Peer.this.getUuid(), peerInfo, abstractMessage));
                        Peer.this.sent++;
                    }
                    Thread.sleep(10L);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    logger.warn("", throwable);
                }
            }
        }
    }

    private class InputHandler
    implements Runnable {
        private final byte[] buffer = new byte[2048];

        private InputHandler() {
        }

        @Override
        public void run() {
            while (Peer.this.running) {
                try {
                    long l;
                    DatagramPacket datagramPacket = new DatagramPacket(this.buffer, 2048);
                    Peer.this.serverSocket.receive(datagramPacket);
                    Envelope envelope = AbstractMessage.receive(Peer.this, datagramPacket);
                    if (envelope == null) continue;
                    AbstractMessage abstractMessage = envelope.getMessage();
                    long l2 = abstractMessage.getSenderTimestamp();
                    long l3 = l2 - (l = System.currentTimeMillis());
                    if (l3 > Peer.this.timeOffset) {
                        Peer.this.timeOffset = l3;
                    }
                    Peer.this.updatePeer(envelope.getPeer().getUuid(), l + Peer.this.timeOffset - l2);
                    Peer.this.inputQueue.add(envelope);
                    Peer.this.received++;
                }
                catch (Throwable throwable) {
                    logger.warn("", throwable);
                }
            }
        }
    }
}

