/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Message;

public class Ack
extends Message {
    private String recipient = null;
    private String messageId = null;
    private String data = null;

    public Ack() {
        this(null, null, null, null);
    }

    public Ack(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Ack(String string, String string2, String string3, String string4) {
        super(14, string);
        this.recipient = string2;
        this.messageId = string3;
        this.data = string4;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            peer.callback(this.messageId, this);
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Ack.serializeUUID(dataOutputStream, this.recipient);
        Ack.serializeUUID(dataOutputStream, this.messageId);
        dataOutputStream.writeBoolean(this.data != null);
        if (this.data != null) {
            dataOutputStream.writeUTF(this.data);
        }
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = Ack.deserializeUUID(dataInputStream);
        this.messageId = Ack.deserializeUUID(dataInputStream);
        if (dataInputStream.readBoolean()) {
            this.data = dataInputStream.readUTF();
        }
    }

    public String getData() {
        return this.data;
    }
}

