/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Message;
import org.structr.net.repository.Repository;

public class Delete
extends Message {
    private PseudoTime time = null;
    private String objectId = null;

    public Delete() {
        this(null, null, null);
    }

    public Delete(String string, String string2, PseudoTime pseudoTime) {
        super(5, string);
        this.objectId = string2;
        this.time = pseudoTime;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        Repository repository = peer.getRepository();
        if (repository.contains(this.objectId)) {
            repository.objectDeleted(this.objectId, this.time);
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Delete.serializeUUID(dataOutputStream, this.objectId);
        this.time.serialize(dataOutputStream);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.objectId = Delete.deserializeUUID(dataInputStream);
        this.time = new PseudoTime();
        this.time.deserialize(dataInputStream);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public PseudoTime getTime() {
        return this.time;
    }
}

