/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Message;

public class Value
extends Message {
    private String messageId = null;
    private String recipient = null;
    private Object value = null;

    public Value() {
        this(null, null, null, null);
    }

    public Value(String string, String string2, String string3, Object object) {
        super(8, string);
        this.messageId = string3;
        this.recipient = string2;
        this.value = object;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            peer.callback(this.messageId, this);
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Value.serializeUUID(dataOutputStream, this.messageId);
        Value.serializeUUID(dataOutputStream, this.recipient);
        this.serializeObject(dataOutputStream, this.value);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.messageId = Value.deserializeUUID(dataInputStream);
        this.recipient = Value.deserializeUUID(dataInputStream);
        this.value = this.deserializeObject(dataInputStream);
    }

    public Object getValue() {
        return this.value;
    }
}

