/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.repository;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.structr.net.data.time.Clock;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.repository.DefaultPossibility;
import org.structr.net.repository.DefaultRepositoryObject;
import org.structr.net.repository.ExternalChangeListener;
import org.structr.net.repository.InternalChangeListener;
import org.structr.net.repository.Repository;
import org.structr.net.repository.RepositoryObject;

public class DefaultRepository
implements Repository {
    private final List<InternalChangeListener> internalChangeListeners = new LinkedList<InternalChangeListener>();
    private final List<ExternalChangeListener> externalChangeListeners = new LinkedList<ExternalChangeListener>();
    private final Map<String, DefaultPossibility> possibilities = new LinkedHashMap<String, DefaultPossibility>();
    private final Map<String, RepositoryObject> objects = new LinkedHashMap<String, RepositoryObject>();
    private Peer peer = null;
    private String uuid = null;

    public DefaultRepository(String string) {
        this.uuid = string;
    }

    public void setPeer(Peer peer) {
        this.peer = peer;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void addInternalChangeListener(InternalChangeListener internalChangeListener) {
        this.internalChangeListeners.add(internalChangeListener);
    }

    @Override
    public void removeInternalChangeListener(InternalChangeListener internalChangeListener) {
        this.internalChangeListeners.remove(internalChangeListener);
    }

    @Override
    public void addExternalChangeListener(ExternalChangeListener externalChangeListener) {
        this.externalChangeListeners.add(externalChangeListener);
        externalChangeListener.onAdd();
    }

    @Override
    public void removeExternalChangeListener(ExternalChangeListener externalChangeListener) {
        this.externalChangeListeners.remove(externalChangeListener);
        externalChangeListener.onRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryObject add(String string, String string2, String string3, String string4, PseudoTime pseudoTime) {
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            DefaultRepositoryObject defaultRepositoryObject = new DefaultRepositoryObject(this, string, string2, string3, string4, pseudoTime);
            this.objects.put(string, defaultRepositoryObject);
            return defaultRepositoryObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryObject create(String string, String string2, String string3, String string4, PseudoTime pseudoTime, Map<String, Object> map) {
        RepositoryObject repositoryObject = this.getObject(string);
        if (repositoryObject == null) {
            repositoryObject = new DefaultRepositoryObject(this, string, string2, string3, string4, pseudoTime);
            Map<String, RepositoryObject> map2 = this.objects;
            synchronized (map2) {
                String object = UUID.randomUUID().toString().replaceAll("\\-", "");
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    repositoryObject.setProperty(pseudoTime, object, entry.getKey(), entry.getValue());
                }
                this.complete(object);
                this.objects.put(string, repositoryObject);
            }
            for (InternalChangeListener internalChangeListener : this.internalChangeListeners) {
                internalChangeListener.onObjectCreation(repositoryObject, map);
            }
            this.notifyCreation(repositoryObject, map);
        }
        return repositoryObject;
    }

    @Override
    public void update(RepositoryObject repositoryObject, String string, String string2, String string3, PseudoTime pseudoTime, Map<String, Object> map) {
        String string4 = UUID.randomUUID().toString().replaceAll("\\-", "");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            repositoryObject.setProperty(pseudoTime, string4, entry.getKey(), entry.getValue());
        }
        this.complete(string4);
        this.notifyModification(repositoryObject, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string, PseudoTime pseudoTime) {
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            RepositoryObject repositoryObject = this.objects.get(string);
            if (repositoryObject != null) {
                this.objects.remove(string);
                this.notifyDeletion(repositoryObject);
            }
            for (InternalChangeListener internalChangeListener : this.internalChangeListeners) {
                internalChangeListener.onObjectDeletion(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryObject objectCreated(String string, String string2, String string3, String string4, PseudoTime pseudoTime, PseudoTime pseudoTime2, Map<String, Object> map) {
        Map<String, RepositoryObject> map2 = this.objects;
        synchronized (map2) {
            RepositoryObject repositoryObject = this.getObject(string);
            if (repositoryObject == null) {
                repositoryObject = new DefaultRepositoryObject(this, string, string2, string3, string4, pseudoTime);
                String string5 = UUID.randomUUID().toString().replaceAll("\\-", "");
                if (map != null) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        repositoryObject.setProperty(pseudoTime2, string5, entry.getKey(), entry.getValue());
                    }
                }
                this.objects.put(string, repositoryObject);
                this.complete(string5);
                this.notifyCreation(repositoryObject, map);
            }
            return repositoryObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectDeleted(String string, PseudoTime pseudoTime) {
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            RepositoryObject repositoryObject = this.objects.get(string);
            if (repositoryObject != null) {
                this.objects.remove(string);
                this.notifyDeletion(repositoryObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String string) {
        this.notifyRepositoryQuery();
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            return this.objects.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryObject getObject(String string) {
        this.notifyRepositoryQuery();
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            return this.objects.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RepositoryObject> getObjects() {
        this.notifyRepositoryQuery();
        LinkedList<RepositoryObject> linkedList = new LinkedList<RepositoryObject>();
        Map<String, RepositoryObject> map = this.objects;
        synchronized (map) {
            linkedList.addAll(this.objects.values());
        }
        return linkedList;
    }

    @Override
    public int objectCount() {
        return this.objects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String beginTransaction(long l) {
        DefaultPossibility defaultPossibility = new DefaultPossibility((Clock)this.peer, l);
        Map<String, DefaultPossibility> map = this.possibilities;
        synchronized (map) {
            this.possibilities.put(defaultPossibility.getUuid(), defaultPossibility);
        }
        return defaultPossibility.getUuid();
    }

    @Override
    public void complete(String string) {
        DefaultPossibility defaultPossibility = this.getPossibility(string);
        if (defaultPossibility != null && !defaultPossibility.isAborted()) {
            defaultPossibility.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPossibility getPossibility(String string) {
        Map<String, DefaultPossibility> map = this.possibilities;
        synchronized (map) {
            DefaultPossibility defaultPossibility = this.possibilities.get(string);
            if (defaultPossibility == null) {
                defaultPossibility = new DefaultPossibility((Clock)this.peer, string);
                this.possibilities.put(string, defaultPossibility);
            }
            return defaultPossibility;
        }
    }

    public void clear() {
        this.objects.clear();
    }

    private void notifyCreation(RepositoryObject repositoryObject, Map<String, Object> map) {
        for (ExternalChangeListener externalChangeListener : this.externalChangeListeners) {
            externalChangeListener.onCreate(repositoryObject, map);
        }
    }

    private void notifyDeletion(RepositoryObject repositoryObject) {
        for (ExternalChangeListener externalChangeListener : this.externalChangeListeners) {
            externalChangeListener.onDelete(repositoryObject);
        }
    }

    private void notifyModification(RepositoryObject repositoryObject, Map<String, Object> map) {
        for (ExternalChangeListener externalChangeListener : this.externalChangeListeners) {
            externalChangeListener.onModify(repositoryObject, map);
        }
    }

    private void notifyRepositoryQuery() {
        for (ExternalChangeListener externalChangeListener : this.externalChangeListeners) {
            externalChangeListener.onQuery();
        }
    }
}

