/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.repository.DefaultPossibility;
import org.structr.net.repository.DefaultRepository;
import org.structr.net.repository.ObjectListener;
import org.structr.net.repository.RepositoryObject;

public class DefaultRepositoryObject
implements RepositoryObject {
    private final SortedMap<PseudoTime, PossibleValue> history = new ConcurrentSkipListMap<PseudoTime, PossibleValue>();
    private final List<ObjectListener> listeners = new LinkedList<ObjectListener>();
    private DefaultRepository parent = null;
    private PseudoTime creationTime = null;
    private PseudoTime deletionTime = null;
    private String deviceId = null;
    private String userId = null;
    private String type = null;
    private String uuid = null;

    public DefaultRepositoryObject(DefaultRepository defaultRepository, String string, String string2, String string3, String string4, PseudoTime pseudoTime) {
        this.creationTime = pseudoTime;
        this.parent = defaultRepository;
        this.deviceId = string3;
        this.userId = string4;
        this.type = string2;
        this.uuid = string;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RepositoryObject) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public PseudoTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public PseudoTime getLastModificationTime() {
        if (!this.history.isEmpty()) {
            return this.history.lastKey();
        }
        return this.creationTime;
    }

    public void printHistory() {
        for (PseudoTime pseudoTime : this.history.keySet()) {
            System.out.println("            " + pseudoTime + ": " + this.history.get(pseudoTime));
        }
        if (!this.history.isEmpty()) {
            System.out.println("            " + this.history.firstKey() + ": " + this.getProperties(this.history.firstKey()));
            System.out.println("            " + this.history.lastKey() + ": " + this.getProperties(this.history.lastKey()));
        }
    }

    @Override
    public void setProperty(PseudoTime pseudoTime, String string, String string2, Object object) {
        Object object2 = this.getProperty(pseudoTime, string, string2);
        if (object2 != null && object2.equals(object)) {
            return;
        }
        PossibleValue possibleValue = (PossibleValue)this.history.get(pseudoTime);
        if (possibleValue != null) {
            if (possibleValue.hasValue(string2)) {
                System.out.println("###### instant: " + pseudoTime.toString());
                System.out.println("REDEFINE: " + this.uuid + ": " + string2 + " = " + object + ", NOT set! " + pseudoTime + ": " + ((PossibleValue)this.history.get(pseudoTime)).getData());
            } else {
                possibleValue.set(string2, object);
            }
        } else {
            DefaultPossibility defaultPossibility = this.parent.getPossibility(string);
            if (defaultPossibility != null) {
                defaultPossibility.addObject(this);
            }
            this.history.put(pseudoTime, new PossibleValue(string, string2, object));
        }
    }

    public Object getProperty(PseudoTime pseudoTime, String string) {
        return this.getProperty(pseudoTime, null, string);
    }

    @Override
    public Object getProperty(PseudoTime pseudoTime, String string, String string2) {
        PossibleValue possibleValue = (PossibleValue)this.history.get(pseudoTime);
        if (possibleValue != null && possibleValue.isComplete(string) && possibleValue.hasValue(string2)) {
            return possibleValue.get(string2);
        }
        LinkedList<PseudoTime> linkedList = new LinkedList<PseudoTime>(this.history.keySet());
        Collections.reverse(linkedList);
        for (PseudoTime pseudoTime2 : linkedList) {
            if (!pseudoTime2.equals(pseudoTime) && !pseudoTime2.before(pseudoTime)) continue;
            PossibleValue possibleValue2 = (PossibleValue)this.history.get(pseudoTime2);
            if (possibleValue2.isComplete(string) && possibleValue2.hasValue(string2)) {
                return possibleValue2.get(string2);
            }
            if (!possibleValue2.isAborted()) continue;
            this.history.remove(pseudoTime2);
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties(PseudoTime pseudoTime) {
        return this.getProperties(pseudoTime, null);
    }

    @Override
    public Map<String, Object> getProperties(PseudoTime pseudoTime, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LinkedList<PseudoTime> linkedList = new LinkedList<PseudoTime>(this.history.keySet());
        Collections.reverse(linkedList);
        for (PseudoTime pseudoTime2 : linkedList) {
            if (!pseudoTime2.equals(pseudoTime) && !pseudoTime2.before(pseudoTime)) continue;
            PossibleValue possibleValue = (PossibleValue)this.history.get(pseudoTime2);
            if (possibleValue.isComplete(string)) {
                for (Map.Entry<String, Object> entry : possibleValue.getData().entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (!possibleValue.isAborted()) continue;
            this.history.remove(pseudoTime2);
        }
        return hashMap;
    }

    @Override
    public void onCommit(String string) {
        LinkedList<PossibleValue> linkedList = new LinkedList<PossibleValue>();
        for (PossibleValue object : this.history.values()) {
            if (string == null || !string.equals(object.getTransactionId())) continue;
            linkedList.add(object);
        }
        for (ObjectListener objectListener : this.listeners) {
            for (PossibleValue possibleValue : linkedList) {
                for (Map.Entry<String, Object> entry : possibleValue.getData().entrySet()) {
                    objectListener.onPropertyChange(this, entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public void addListener(ObjectListener objectListener) {
        this.listeners.add(objectListener);
    }

    @Override
    public void removeListener(ObjectListener objectListener) {
        this.listeners.remove(objectListener);
    }

    private class PossibleValue {
        private Map<String, Object> data = new HashMap<String, Object>();
        private String transactionId = null;

        public PossibleValue(String string, String string2, Object object) {
            this.transactionId = string;
            this.data.put(string2, object);
        }

        public String toString() {
            return this.transactionId;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public boolean isComplete(String string) {
            if (this.transactionId == null) {
                return true;
            }
            if (this.transactionId.equals(string)) {
                return true;
            }
            DefaultPossibility defaultPossibility = DefaultRepositoryObject.this.parent.getPossibility(this.transactionId);
            if (defaultPossibility != null) {
                return defaultPossibility.isComplete();
            }
            return false;
        }

        public boolean isAborted() {
            if (this.transactionId == null) {
                return false;
            }
            DefaultPossibility defaultPossibility = DefaultRepositoryObject.this.parent.getPossibility(this.transactionId);
            if (defaultPossibility != null) {
                return defaultPossibility.isAborted();
            }
            return false;
        }

        public boolean hasValue(String string) {
            return this.data.containsKey(string);
        }

        public Object get(String string) {
            return this.data.get(string);
        }

        public void set(String string, Object object) {
            this.data.put(string, object);
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

