/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.media.ConverterProcess;
import org.structr.media.FrameGrabberProcess;
import org.structr.media.GetMetadataProcess;
import org.structr.media.GetVideoInfoProcess;
import org.structr.media.SetMetadataProcess;
import org.structr.media.VideoFile;
import org.structr.media.VideoHelper;
import org.structr.web.entity.Image;

public class AVConv
implements VideoHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)AVConv.class.getName());
    private static final ExecutorService service = Executors.newCachedThreadPool();
    private SecurityContext securityContext = null;
    private VideoFile inputVideo = null;
    private String outputFileName = null;

    private AVConv(SecurityContext securityContext, VideoFile videoFile, String string) {
        this.securityContext = securityContext;
        this.inputVideo = videoFile;
        this.outputFileName = string;
    }

    public static VideoHelper newInstance(SecurityContext securityContext, VideoFile videoFile) {
        return AVConv.newInstance(securityContext, videoFile, null);
    }

    public static VideoHelper newInstance(SecurityContext securityContext, VideoFile videoFile, String string) {
        return new AVConv(securityContext, videoFile, string);
    }

    @Override
    public Future<VideoFile> doConversion(String string) {
        return service.submit(new ConverterProcess(this.securityContext, this.inputVideo, this.outputFileName, string));
    }

    @Override
    public Future<Image> grabFrame(String string, String string2, long l) {
        return service.submit(new FrameGrabberProcess(this.securityContext, this.inputVideo, string2, l, string));
    }

    @Override
    public Map<String, String> getMetadata() {
        try {
            return (Map)service.submit(new GetMetadataProcess(this.securityContext, this.inputVideo)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.warn("", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void setMetadata(String string, String string2) {
        try {
            service.submit(new SetMetadataProcess(this.securityContext, this.inputVideo, string, string2)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.warn("", (Throwable)exception);
        }
    }

    @Override
    public void setMetadata(Map<String, String> map) {
        try {
            service.submit(new SetMetadataProcess(this.securityContext, this.inputVideo, map)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.warn("", (Throwable)exception);
        }
    }

    @Override
    public Map<String, Object> getVideoInfo() {
        try {
            return (Map)service.submit(new GetVideoInfoProcess(this.securityContext, this.inputVideo.getDiskFilePath(this.securityContext))).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.warn("", (Throwable)exception);
            return null;
        }
    }
}

