/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.media.VideoFile;
import org.structr.util.AbstractProcess;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Image;

public class FrameGrabberProcess
extends AbstractProcess<Image> {
    private static final Logger logger = LoggerFactory.getLogger((String)FrameGrabberProcess.class.getName());
    private Image newFile = null;
    private VideoFile inputFile = null;
    private String outputFileName = null;
    private String imageName = null;
    private String scriptName = null;
    private String fileExtension = null;
    private long timeIndex = -1L;

    public FrameGrabberProcess(SecurityContext securityContext, VideoFile videoFile, String string, long l, String string2) {
        super(securityContext);
        this.inputFile = videoFile;
        this.scriptName = string2;
        this.fileExtension = ".tmp-" + System.currentTimeMillis();
        this.timeIndex = l;
        this.imageName = string;
    }

    public void preprocess() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.newFile = (Image)FileHelper.createFile((SecurityContext)this.securityContext, (byte[])new byte[0], null, Image.class, (String)this.imageName);
            this.outputFileName = this.newFile.getFileOnDisk().getAbsolutePath();
            tx.success();
        }
        catch (IOException | FrameworkException throwable) {
            logger.warn("", throwable);
        }
    }

    public StringBuilder getCommandLine() {
        String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{"VideoFile", this.scriptName}).getValue();
        if (StringUtils.isNotBlank((String)string)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" ");
            stringBuilder.append(this.inputFile.getDiskFilePath(this.securityContext));
            stringBuilder.append(" ");
            stringBuilder.append(this.outputFileName);
            stringBuilder.append(this.fileExtension);
            stringBuilder.append(" ");
            stringBuilder.append(this.timeIndex);
            return stringBuilder;
        }
        logger.warn("No VideoFile.{} registered in structr.conf.", (Object)this.scriptName);
        return null;
    }

    public Image processExited(int n) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        if (n == 0) {
            try (Tx tx = app.tx();){
                File file = new File(this.outputFileName + this.fileExtension);
                File file2 = new File(this.outputFileName);
                if (file.exists()) {
                    Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    FileHelper.updateMetadata((FileBase)this.newFile);
                    this.inputFile.setProperty((PropertyKey)VideoFile.posterImage, this.newFile);
                }
                tx.success();
            }
            catch (IOException | FrameworkException throwable) {
                logger.warn("", throwable);
            }
        } else {
            try (Tx tx = app.tx();){
                app.delete((NodeInterface)this.newFile);
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                logger.warn("", (Throwable)frameworkException);
            }
        }
        return this.newFile;
    }
}

