/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.media.VideoFile;
import org.structr.util.AbstractProcess;

public class GetMetadataProcess
extends AbstractProcess<Map<String, String>> {
    private static final Logger logger = LoggerFactory.getLogger((String)GetMetadataProcess.class.getName());
    private VideoFile inputVideo = null;

    public GetMetadataProcess(SecurityContext securityContext, VideoFile videoFile) {
        super(securityContext);
        this.inputVideo = videoFile;
    }

    public void preprocess() {
    }

    public StringBuilder getCommandLine() {
        StringBuilder stringBuilder = new StringBuilder("avconv -y -loglevel quiet -i ");
        stringBuilder.append(this.inputVideo.getDiskFilePath(this.securityContext));
        stringBuilder.append(" -f ffmetadata -");
        return stringBuilder;
    }

    public Map<String, String> processExited(int n) {
        if (n == 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            Properties properties = new Properties();
            try {
                properties.load(new StringReader(this.outputStream()));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string;
                    String string2 = entry.getKey().toString();
                    if (!this.accept(string2, string = entry.getValue().toString())) continue;
                    linkedHashMap.put(string2, string);
                }
            }
            catch (IOException iOException) {
                logger.warn("", (Throwable)iOException);
            }
            return linkedHashMap;
        }
        return null;
    }

    protected boolean accept(String string, String string2) {
        return string != null && !string.startsWith(";");
    }
}

