/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.media.VideoFile;
import org.structr.util.AbstractProcess;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;

public class SetMetadataProcess
extends AbstractProcess<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)SetMetadataProcess.class.getName());
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();
    private VideoFile inputVideo = null;
    private String outputFileName = null;
    private String fileExtension = null;

    public SetMetadataProcess(SecurityContext securityContext, VideoFile videoFile, String string, String string2) {
        this(securityContext, videoFile, SetMetadataProcess.toMap(string, string2));
    }

    public SetMetadataProcess(SecurityContext securityContext, VideoFile videoFile, Map<String, String> map) {
        super(securityContext);
        this.outputFileName = videoFile.getDiskFilePath(securityContext);
        this.inputVideo = videoFile;
        this.metadata.putAll(map);
    }

    public void preprocess() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.fileExtension = StringUtils.substringAfterLast((String)this.inputVideo.getName(), (String)".");
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            // empty catch block
        }
    }

    public StringBuilder getCommandLine() {
        if (this.metadata.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("avconv -y -i ");
        String string = this.inputVideo.getDiskFilePath(this.securityContext);
        stringBuilder.append(string);
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            try {
                stringBuilder.append(" -metadata ");
                stringBuilder.append(this.clean(entry.getKey()));
                stringBuilder.append("=\"");
                stringBuilder.append(this.escape(entry.getValue()));
                stringBuilder.append("\"");
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        stringBuilder.append(" -codec copy ");
        stringBuilder.append(string);
        if (!this.fileExtension.isEmpty()) {
            stringBuilder.append(".");
            stringBuilder.append(this.fileExtension);
        }
        return stringBuilder;
    }

    public Void processExited(int n) {
        if (n == 0) {
            try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
                File file = new File(this.outputFileName + "." + this.fileExtension);
                File file2 = new File(this.outputFileName);
                if (file.exists()) {
                    Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    FileHelper.updateMetadata((FileBase)this.inputVideo);
                }
                tx.success();
            }
            catch (IOException | FrameworkException throwable) {
                logger.warn("", throwable);
            }
        }
        return null;
    }

    protected boolean accept(String string, String string2) {
        return string != null && !string.startsWith(";");
    }

    private String clean(String string) {
        return string.replaceAll("[\\W]+", "");
    }

    private String escape(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    private static final Map<String, String> toMap(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string, string2);
        return linkedHashMap;
    }
}

