/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.function.BiFunction;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.HandshakeOutcome;

public class ProtocolChooser {
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private final Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> availableVersions;
    private final boolean encryptionRequired;
    private final boolean isEncrypted;
    private final ByteBuffer handShake = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
    private BoltProtocol protocol;

    public ProtocolChooser(Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> availableVersions, boolean encryptionRequired, boolean isEncrypted) {
        this.availableVersions = availableVersions;
        this.encryptionRequired = encryptionRequired;
        this.isEncrypted = isEncrypted;
    }

    public HandshakeOutcome handleVersionHandshakeChunk(ByteBuf buffer, Channel ch) {
        if (this.encryptionRequired && !this.isEncrypted) {
            return HandshakeOutcome.INSECURE_HANDSHAKE;
        }
        if (this.handShake.remaining() > buffer.readableBytes()) {
            this.handShake.limit(this.handShake.position() + buffer.readableBytes());
            buffer.readBytes(this.handShake);
            this.handShake.limit(this.handShake.capacity());
        } else {
            buffer.readBytes(this.handShake);
        }
        if (this.handShake.remaining() == 0) {
            this.handShake.flip();
            if (this.handShake.getInt() != 1616949271) {
                return HandshakeOutcome.INVALID_HANDSHAKE;
            }
            for (int i = 0; i < 4; ++i) {
                long suggestion = (long)this.handShake.getInt() & 0xFFFFFFFFL;
                if (!this.availableVersions.containsKey(suggestion)) continue;
                this.protocol = this.availableVersions.get(suggestion).apply(ch, this.isEncrypted);
                return HandshakeOutcome.PROTOCOL_CHOSEN;
            }
            return HandshakeOutcome.NO_APPLICABLE_PROTOCOL;
        }
        return HandshakeOutcome.PARTIAL_HANDSHAKE;
    }

    public BoltProtocol chosenProtocol() {
        return this.protocol;
    }
}

