/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.logging.Log;

class MessageProcessingHandler
implements BoltResponseHandler {
    protected final Map<String, Object> metadata = new HashMap<String, Object>();
    protected final Log log;
    protected final BoltWorker worker;
    protected final BoltResponseMessageHandler<IOException> handler;
    private Neo4jError error;
    private final Runnable onFinish;
    private boolean ignored;

    static void publishError(BoltResponseMessageHandler<IOException> out, Neo4jError error) throws IOException {
        if (error.isFatal()) {
            out.onFatal(error.status(), error.message());
        } else {
            out.onFailure(error.status(), error.message());
        }
    }

    MessageProcessingHandler(BoltResponseMessageHandler<IOException> handler, Runnable onFinish, BoltWorker worker, Log logger) {
        this.handler = handler;
        this.onFinish = onFinish;
        this.worker = worker;
        this.log = logger;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onRecords(BoltResult result, boolean pull) throws Exception {
    }

    @Override
    public void onMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    @Override
    public void markIgnored() {
        this.ignored = true;
    }

    @Override
    public void markFailed(Neo4jError error) {
        this.error = error;
    }

    @Override
    public void onFinish() {
        try {
            if (this.ignored) {
                this.handler.onIgnored();
            } else if (this.error != null) {
                MessageProcessingHandler.publishError(this.handler, this.error);
            } else {
                this.handler.onSuccess(this.getMetadata());
            }
        }
        catch (Throwable e) {
            this.worker.halt();
            this.log.error("Failed to write response to driver", e);
        }
        finally {
            this.onFinish.run();
            this.clearState();
        }
    }

    Map<String, Object> getMetadata() {
        return this.metadata;
    }

    void clearState() {
        this.error = null;
        this.ignored = false;
        this.metadata.clear();
    }
}

