/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueNode;
import org.neo4j.bolt.v1.messaging.infrastructure.ValuePath;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueUnboundRelationship;
import org.neo4j.collection.primitive.PrimitiveLongIntKeyValueArray;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class PathPack {
    private static final int STRUCT_FIELD_COUNT = 5;
    private static final int NO_SUCH_ID = -1;

    public static class Unpacker {
        public ValuePath unpack(Neo4jPack.Unpacker unpacker) throws IOException {
            assert (unpacker.unpackStructHeader() == 5L);
            assert (unpacker.unpackStructSignature() == 'P');
            return this.unpackFields(unpacker);
        }

        public ValuePath unpackFields(Neo4jPack.Unpacker unpacker) throws IOException {
            List<Node> nodes = this.unpackNodes(unpacker);
            List<Relationship> relationships = this.unpackRelationships(unpacker);
            List<Integer> sequence = this.unpackSequence(unpacker);
            return new ValuePath(nodes, relationships, sequence);
        }

        private List<Node> unpackNodes(Neo4jPack.Unpacker unpacker) throws IOException {
            int count = (int)unpacker.unpackListHeader();
            if (count > 0) {
                ArrayList<Node> items = new ArrayList<Node>(count);
                for (int i = 0; i < count; ++i) {
                    items.add(ValueNode.unpack(unpacker));
                }
                return items;
            }
            return Collections.emptyList();
        }

        private List<Relationship> unpackRelationships(Neo4jPack.Unpacker unpacker) throws IOException {
            int count = (int)unpacker.unpackListHeader();
            if (count > 0) {
                ArrayList<Relationship> items = new ArrayList<Relationship>(count);
                for (int i = 0; i < count; ++i) {
                    items.add(ValueUnboundRelationship.unpack(unpacker));
                }
                return items;
            }
            return Collections.emptyList();
        }

        private List<Integer> unpackSequence(Neo4jPack.Unpacker unpacker) throws IOException {
            int count = (int)unpacker.unpackListHeader();
            if (count > 0) {
                ArrayList<Integer> items = new ArrayList<Integer>(count);
                for (int i = 0; i < count; ++i) {
                    items.add(unpacker.unpackInteger());
                }
                return items;
            }
            return Collections.emptyList();
        }
    }

    public static class Packer {
        private static final int INITIAL_PATH_CAPACITY = 500;
        private final PrimitiveLongIntKeyValueArray nodes = new PrimitiveLongIntKeyValueArray(501);
        private final PrimitiveLongIntKeyValueArray relationships = new PrimitiveLongIntKeyValueArray(500);

        private void packNodes(Neo4jPack.Packer packer, Path path) throws IOException {
            this.nodes.reset(path.length() + 1);
            for (Node node : path.nodes()) {
                this.nodes.putIfAbsent(node.getId(), this.nodes.size());
            }
            int size = this.nodes.size();
            packer.packListHeader(size);
            if (size > 0) {
                Iterator iterator = path.nodes().iterator();
                Node node = (Node)iterator.next();
                for (long id : this.nodes.keys()) {
                    while (node.getId() != id) {
                        node = (Node)iterator.next();
                    }
                    ValueNode.pack(packer, node);
                    if (!iterator.hasNext()) continue;
                    node = (Node)iterator.next();
                }
            }
        }

        private void packRelationships(Neo4jPack.Packer packer, Path path) throws IOException {
            this.relationships.reset(path.length());
            for (Relationship rel : path.relationships()) {
                this.relationships.putIfAbsent(rel.getId(), this.relationships.size() + 1);
            }
            int size = this.relationships.size();
            packer.packListHeader(size);
            if (size > 0) {
                Iterator iterator = path.relationships().iterator();
                Relationship rel = (Relationship)iterator.next();
                for (long id : this.relationships.keys()) {
                    while (rel.getId() != id) {
                        rel = (Relationship)iterator.next();
                    }
                    ValueUnboundRelationship.pack(packer, ValueUnboundRelationship.unbind(rel));
                    if (!iterator.hasNext()) continue;
                    rel = (Relationship)iterator.next();
                }
            }
        }

        public void pack(Neo4jPack.Packer packer, Path path) throws IOException {
            packer.packStructHeader(3, (byte)80);
            this.packNodes(packer, path);
            this.packRelationships(packer, path);
            Node node = null;
            packer.packListHeader(2 * path.length());
            int i = 0;
            for (PropertyContainer entity : path) {
                if (i % 2 == 0) {
                    node = (Node)entity;
                    if (i > 0) {
                        int index = this.nodes.getOrDefault(node.getId(), -1);
                        packer.pack(index);
                    }
                } else {
                    Relationship relationship = (Relationship)entity;
                    int index = this.relationships.getOrDefault(relationship.getId(), -1);
                    if (node != null && node.getId() == relationship.getStartNode().getId()) {
                        packer.pack(index);
                    } else {
                        packer.pack(-index);
                    }
                }
                ++i;
            }
        }
    }
}

