/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.io.pagecache.PageCursor;

class InternalTreeLogic<KEY, VALUE> {
    private final IdProvider idProvider;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final Layout<KEY, VALUE> layout;
    private final KEY newKeyPlaceHolder;
    private final KEY readKey;
    private final VALUE readValue;
    private Level<KEY>[] levels = new Level[0];
    private int currentLevel = -1;

    InternalTreeLogic(IdProvider idProvider, TreeNode<KEY, VALUE> bTreeNode, Layout<KEY, VALUE> layout) {
        this.idProvider = idProvider;
        this.bTreeNode = bTreeNode;
        this.layout = layout;
        this.newKeyPlaceHolder = layout.newKey();
        this.readKey = layout.newKey();
        this.readValue = layout.newValue();
        this.ensureStackCapacity(10);
    }

    private void ensureStackCapacity(int depth) {
        if (depth > this.levels.length) {
            int oldStackLength = this.levels.length;
            this.levels = Arrays.copyOf(this.levels, depth);
            for (int i = oldStackLength; i < depth; ++i) {
                this.levels[i] = new Level<KEY>(this.layout);
            }
        }
    }

    protected void initialize(PageCursor cursorAtRoot) {
        this.currentLevel = 0;
        Level<KEY> level = this.levels[this.currentLevel];
        ((Level)level).treeNodeId = cursorAtRoot.getCurrentPageId();
        ((Level)level).lowerIsOpenEnded = true;
        ((Level)level).upperIsOpenEnded = true;
    }

    private boolean popLevel(PageCursor cursor) throws IOException {
        --this.currentLevel;
        if (this.currentLevel >= 0) {
            Level<KEY> level = this.levels[this.currentLevel];
            TreeNode.goTo(cursor, "parent", ((Level)level).treeNodeId);
            return true;
        }
        return false;
    }

    private void moveToCorrectLeaf(PageCursor cursor, KEY key, long stableGeneration, long unstableGeneration) throws IOException {
        int previousLevel = this.currentLevel;
        while (!this.levels[this.currentLevel].covers(key)) {
            --this.currentLevel;
        }
        if (this.currentLevel != previousLevel) {
            TreeNode.goTo(cursor, "parent", ((Level)this.levels[this.currentLevel]).treeNodeId);
        }
        while (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            int searchResult = this.search(cursor, key, this.readKey, keyCount);
            int childPos = KeySearch.positionOf(searchResult);
            if (KeySearch.isHit(searchResult)) {
                ++childPos;
            }
            Level<KEY> parentLevel = this.levels[this.currentLevel];
            ++this.currentLevel;
            this.ensureStackCapacity(this.currentLevel + 1);
            Level<KEY> level = this.levels[this.currentLevel];
            ((Level)level).childPos = childPos;
            ((Level)level).lowerIsOpenEnded = childPos == 0 && !TreeNode.isNode(TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration));
            if (!((Level)level).lowerIsOpenEnded) {
                if (childPos == 0) {
                    this.layout.copyKey(((Level)parentLevel).lower, ((Level)level).lower);
                    ((Level)level).lowerIsOpenEnded = ((Level)parentLevel).lowerIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, ((Level)level).lower, childPos - 1);
                }
            }
            ((Level)level).upperIsOpenEnded = childPos >= keyCount && !TreeNode.isNode(TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration));
            if (!((Level)level).upperIsOpenEnded) {
                if (childPos == keyCount) {
                    this.layout.copyKey(((Level)parentLevel).upper, ((Level)level).upper);
                    ((Level)level).upperIsOpenEnded = ((Level)parentLevel).upperIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, ((Level)level).upper, childPos);
                }
            }
            long childId = this.bTreeNode.childAt(cursor, childPos, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(childId, false);
            TreeNode.goTo(cursor, "child", childId);
            ((Level)level).treeNodeId = cursor.getCurrentPageId();
        }
        assert (TreeNode.isLeaf(cursor)) : "Ended up on a tree node which isn't a leaf after moving cursor towards " + key + ", cursor is at " + cursor.getCurrentPageId();
    }

    void insert(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<VALUE> valueMerger, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        this.insertInLeaf(cursor, structurePropagation, key, value, valueMerger, stableGeneration, unstableGeneration);
        while (structurePropagation.hasMidChildUpdate || structurePropagation.hasRightKeyInsert) {
            int pos = ((Level)this.levels[this.currentLevel]).childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
            }
            if (!structurePropagation.hasRightKeyInsert) continue;
            structurePropagation.hasRightKeyInsert = false;
            this.insertInInternal(cursor, structurePropagation, TreeNode.keyCount(cursor), structurePropagation.rightKey, structurePropagation.rightChild, stableGeneration, unstableGeneration);
        }
    }

    private int search(PageCursor cursor, KEY key, KEY readKey, int keyCount) {
        int searchResult = KeySearch.search(cursor, this.bTreeNode, key, readKey, keyCount);
        KeySearch.assertSuccess(searchResult);
        return searchResult;
    }

    private boolean cursorIsAtExpectedLocation(PageCursor cursor) {
        assert (this.currentLevel >= 0) : "Uninitialized tree logic, currentLevel:" + this.currentLevel;
        assert (cursor.getCurrentPageId() == ((Level)this.levels[this.currentLevel]).treeNodeId) : "Expected cursor to be at page:" + Level.access$000(this.levels[this.currentLevel]) + " at level:" + this.currentLevel + ", but was at page:" + cursor.getCurrentPageId();
        return true;
    }

    private void insertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        if (keyCount < this.bTreeNode.internalMaxKeyCount()) {
            int pos = KeySearch.positionOf(this.search(cursor, primKey, this.readKey, keyCount));
            this.bTreeNode.insertKeyAt(cursor, primKey, pos, keyCount);
            this.bTreeNode.insertChildAt(cursor, rightChild, pos + 1, keyCount, stableGeneration, unstableGeneration);
            TreeNode.setKeyCount(cursor, keyCount + 1);
            return;
        }
        this.layout.copyKey(structurePropagation.rightKey, this.newKeyPlaceHolder);
        this.splitInternal(cursor, structurePropagation, this.newKeyPlaceHolder, rightChild, keyCount, stableGeneration, unstableGeneration);
    }

    private void splitInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, long newRightChild, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, newKey, this.readKey, keyCount));
        int keyCountAfterInsert = keyCount + 1;
        int middlePos = InternalTreeLogic.middle(keyCountAfterInsert);
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        if (middlePos == pos) {
            this.layout.copyKey(newKey, structurePropagation.rightKey);
        } else {
            this.bTreeNode.keyAt(cursor, structurePropagation.rightKey, pos < middlePos ? middlePos - 1 : middlePos);
        }
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            TreeNode.initializeInternal(rightCursor, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            int rightKeyCount = keyCountAfterInsert - middlePos - 1;
            if (pos < middlePos) {
                cursor.copyTo(this.bTreeNode.keyOffset(middlePos), rightCursor, this.bTreeNode.keyOffset(0), rightKeyCount * this.bTreeNode.keySize());
                cursor.copyTo(this.bTreeNode.childOffset(middlePos), rightCursor, this.bTreeNode.childOffset(0), (rightKeyCount + 1) * TreeNode.childSize());
            } else {
                int countAfterPos;
                int countBeforePos = pos - (middlePos + 1);
                if (countBeforePos > 0) {
                    cursor.copyTo(this.bTreeNode.keyOffset(middlePos + 1), rightCursor, this.bTreeNode.keyOffset(0), countBeforePos * this.bTreeNode.keySize());
                }
                if (countBeforePos >= 0) {
                    this.bTreeNode.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
                }
                if ((countAfterPos = keyCount - pos) > 0) {
                    cursor.copyTo(this.bTreeNode.keyOffset(pos), rightCursor, this.bTreeNode.keyOffset(countBeforePos + 1), countAfterPos * this.bTreeNode.keySize());
                }
                if ((countBeforePos = pos - middlePos) > 0) {
                    cursor.copyTo(this.bTreeNode.childOffset(middlePos + 1), rightCursor, this.bTreeNode.childOffset(0), countBeforePos * TreeNode.childSize());
                }
                this.bTreeNode.insertChildAt(rightCursor, newRightChild, countBeforePos, countBeforePos, stableGeneration, unstableGeneration);
                if (countAfterPos > 0) {
                    cursor.copyTo(this.bTreeNode.childOffset(pos + 1), rightCursor, this.bTreeNode.childOffset(countBeforePos + 1), countAfterPos * TreeNode.childSize());
                }
            }
            TreeNode.setKeyCount(rightCursor, rightKeyCount);
        }
        if (TreeNode.isNode(oldRight)) {
            TreeNode.goTo(cursor, "old right sibling", oldRight);
            TreeNode.setLeftSibling(cursor, newRight, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "left", current);
        TreeNode.setKeyCount(cursor, middlePos);
        if (pos < middlePos) {
            this.bTreeNode.insertKeyAt(cursor, newKey, pos, middlePos - 1);
            this.bTreeNode.insertChildAt(cursor, newRightChild, pos + 1, middlePos - 1, stableGeneration, unstableGeneration);
        }
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private static int middle(int keyCountAfterInsert) {
        return keyCountAfterInsert / 2;
    }

    private void insertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<VALUE> valueMerger, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        if (KeySearch.isHit(search)) {
            this.bTreeNode.valueAt(cursor, this.readValue, pos);
            VALUE mergedValue = valueMerger.merge(this.readValue, value);
            if (mergedValue != null) {
                this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
                this.bTreeNode.setValueAt(cursor, mergedValue, pos);
            }
            return;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        if (keyCount < this.bTreeNode.leafMaxKeyCount()) {
            this.bTreeNode.insertKeyAt(cursor, key, pos, keyCount);
            this.bTreeNode.insertValueAt(cursor, value, pos, keyCount);
            TreeNode.setKeyCount(cursor, keyCount + 1);
            return;
        }
        this.splitLeaf(cursor, structurePropagation, key, value, keyCount, stableGeneration, unstableGeneration);
    }

    private void splitLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, VALUE newValue, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, newKey, this.readKey, keyCount));
        int keyCountAfterInsert = keyCount + 1;
        int middlePos = InternalTreeLogic.middle(keyCountAfterInsert);
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        if (middlePos == pos) {
            this.layout.copyKey(newKey, structurePropagation.rightKey);
        } else {
            this.bTreeNode.keyAt(cursor, structurePropagation.rightKey, pos < middlePos ? middlePos - 1 : middlePos);
        }
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            TreeNode.initializeLeaf(rightCursor, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            int rightKeyCount = keyCountAfterInsert - middlePos;
            if (pos < middlePos) {
                this.copyKeysAndValues(cursor, middlePos - 1, rightCursor, 0, rightKeyCount);
            } else {
                int countBeforePos = pos - middlePos;
                if (countBeforePos > 0) {
                    this.copyKeysAndValues(cursor, middlePos, rightCursor, 0, countBeforePos);
                }
                this.bTreeNode.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
                this.bTreeNode.insertValueAt(rightCursor, newValue, countBeforePos, countBeforePos);
                int countAfterPos = keyCount - pos;
                if (countAfterPos > 0) {
                    this.copyKeysAndValues(cursor, pos, rightCursor, countBeforePos + 1, countAfterPos);
                }
            }
            TreeNode.setKeyCount(rightCursor, rightKeyCount);
        }
        if (TreeNode.isNode(oldRight)) {
            var20_15 = null;
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
            catch (Throwable throwable) {
                var20_15 = throwable;
                throw throwable;
            }
        }
        if (pos < middlePos) {
            this.bTreeNode.insertKeyAt(cursor, newKey, pos, middlePos - 1);
            this.bTreeNode.insertValueAt(cursor, newValue, pos, middlePos - 1);
        }
        TreeNode.setKeyCount(cursor, middlePos);
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        fromCursor.copyTo(this.bTreeNode.keyOffset(fromPos), toCursor, this.bTreeNode.keyOffset(toPos), count * this.bTreeNode.keySize());
        fromCursor.copyTo(this.bTreeNode.valueOffset(fromPos), toCursor, this.bTreeNode.valueOffset(toPos), count * this.bTreeNode.valueSize());
    }

    VALUE remove(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        if (!this.removeFromLeaf(cursor, structurePropagation, key, into, stableGeneration, unstableGeneration)) {
            return null;
        }
        block8: while (structurePropagation.hasLeftChildUpdate || structurePropagation.hasMidChildUpdate || structurePropagation.hasRightChildUpdate || structurePropagation.hasLeftKeyReplace || structurePropagation.hasRightKeyReplace) {
            int pos = ((Level)this.levels[this.currentLevel]).childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasLeftChildUpdate) {
                structurePropagation.hasLeftChildUpdate = false;
                if (pos == 0) {
                    this.updateRightmostChildInLeftSibling(cursor, structurePropagation.leftChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.leftChild, pos - 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
            }
            if (structurePropagation.hasRightChildUpdate) {
                structurePropagation.hasRightChildUpdate = false;
                int keyCount = TreeNode.keyCount(cursor);
                if (pos == keyCount) {
                    this.updateLeftmostChildInRightSibling(cursor, structurePropagation.rightChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.rightChild, pos + 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasLeftKeyReplace && this.levels[this.currentLevel].covers(structurePropagation.leftKey)) {
                structurePropagation.hasLeftKeyReplace = false;
                switch (structurePropagation.keyReplaceStrategy) {
                    case REPLACE: {
                        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
                        this.bTreeNode.setKeyAt(cursor, structurePropagation.leftKey, pos - 1);
                        break;
                    }
                    case BUBBLE: {
                        this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos - 1, stableGeneration, unstableGeneration);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown KeyReplaceStrategy " + (Object)((Object)structurePropagation.keyReplaceStrategy));
                    }
                }
            }
            if (!structurePropagation.hasRightKeyReplace || !this.levels[this.currentLevel].covers(structurePropagation.rightKey)) continue;
            structurePropagation.hasRightKeyReplace = false;
            switch (structurePropagation.keyReplaceStrategy) {
                case REPLACE: {
                    this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
                    this.bTreeNode.setKeyAt(cursor, structurePropagation.rightKey, pos);
                    continue block8;
                }
                case BUBBLE: {
                    this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown KeyReplaceStrategy " + (Object)((Object)structurePropagation.keyReplaceStrategy));
        }
        if (this.currentLevel <= 0) {
            this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
        }
        return into;
    }

    private void tryShrinkTree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        int rootKeyCount = TreeNode.keyCount(cursor);
        while (rootKeyCount == 0 && TreeNode.isInternal(cursor)) {
            long oldRoot = cursor.getCurrentPageId();
            long onlyChildOfRoot = this.bTreeNode.childAt(cursor, 0, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(onlyChildOfRoot, false);
            structurePropagation.hasMidChildUpdate = true;
            structurePropagation.midChild = onlyChildOfRoot;
            this.idProvider.releaseId(stableGeneration, unstableGeneration, oldRoot);
            TreeNode.goTo(cursor, "child", onlyChildOfRoot);
            rootKeyCount = TreeNode.keyCount(cursor);
        }
    }

    private void updateMidChild(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int childPos, long stableGeneration, long unstableGeneration) {
        structurePropagation.hasMidChildUpdate = false;
        this.bTreeNode.setChildAt(cursor, structurePropagation.midChild, childPos, stableGeneration, unstableGeneration);
    }

    private void replaceKeyByBubbleRightmostFromSubtree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int subtreePosition, long stableGeneration, long unstableGeneration) throws IOException {
        long currentPageId = cursor.getCurrentPageId();
        long subtree = this.bTreeNode.childAt(cursor, subtreePosition, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(subtree, false);
        TreeNode.goTo(cursor, "child", subtree);
        boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration);
        if (structurePropagation.hasMidChildUpdate) {
            this.updateMidChild(cursor, structurePropagation, subtreePosition, stableGeneration, unstableGeneration);
        }
        if (foundKeyBelow) {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.bTreeNode.setKeyAt(cursor, structurePropagation.bubbleKey, subtreePosition);
        } else {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            int keyCount = TreeNode.keyCount(cursor);
            this.simplyRemoveFromInternal(cursor, keyCount, subtreePosition, subtreePosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bubbleRightmostKeyRecursive(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long previousNode, long stableGeneration, long unstableGeneration) throws IOException {
        try {
            if (TreeNode.isLeaf(cursor)) {
                boolean bl = false;
                return bl;
            }
            long currentPageId = cursor.getCurrentPageId();
            int keyCount = TreeNode.keyCount(cursor);
            long rightmostSubtree = this.bTreeNode.childAt(cursor, keyCount, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(rightmostSubtree, false);
            TreeNode.goTo(cursor, "child", rightmostSubtree);
            boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration);
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
            }
            if (foundKeyBelow) {
                boolean bl = true;
                return bl;
            }
            if (keyCount == 0) {
                this.connectLeftAndRightSibling(cursor, stableGeneration, unstableGeneration);
                this.idProvider.releaseId(stableGeneration, unstableGeneration, currentPageId);
                boolean bl = false;
                return bl;
            }
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.bTreeNode.keyAt(cursor, structurePropagation.bubbleKey, keyCount - 1);
            this.simplyRemoveFromInternal(cursor, keyCount, keyCount - 1, keyCount);
            boolean bl = true;
            return bl;
        }
        finally {
            TreeNode.goTo(cursor, "back to previous node", previousNode);
        }
    }

    private int simplyRemoveFromInternal(PageCursor cursor, int keyCount, int keyPos, int childPos) {
        this.bTreeNode.removeKeyAt(cursor, keyPos, keyCount);
        this.bTreeNode.removeChildAt(cursor, childPos, keyCount);
        int newKeyCount = keyCount - 1;
        TreeNode.setKeyCount(cursor, newKeyCount);
        return newKeyCount;
    }

    private void updateRightmostChildInLeftSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, false);
        try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(leftSibling);){
            TreeNode.goTo(leftSiblingCursor, "left sibling", leftSibling);
            int keyCount = TreeNode.keyCount(leftSiblingCursor);
            this.bTreeNode.setChildAt(leftSiblingCursor, childPointer, keyCount, stableGeneration, unstableGeneration);
        }
    }

    private void updateLeftmostChildInRightSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, false);
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(rightSibling);){
            TreeNode.goTo(rightSiblingCursor, "right sibling", rightSibling);
            this.bTreeNode.setChildAt(rightSiblingCursor, childPointer, 0, stableGeneration, unstableGeneration);
        }
    }

    private boolean removeFromLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        boolean hit = KeySearch.isHit(search);
        if (!hit) {
            return false;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        keyCount = this.simplyRemoveFromLeaf(cursor, into, keyCount, pos);
        if (keyCount < (this.bTreeNode.leafMaxKeyCount() + 1) / 2) {
            this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
        }
        return true;
    }

    private void underflowInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(leftSibling));){
                leftSiblingCursor.next();
                int leftSiblingKeyCount = TreeNode.keyCount(leftSiblingCursor);
                if (keyCount + leftSiblingKeyCount >= this.bTreeNode.leafMaxKeyCount()) {
                    this.createSuccessorIfNeeded(leftSiblingCursor, structurePropagation, StructurePropagation.UPDATE_LEFT_CHILD, stableGeneration, unstableGeneration);
                    this.rebalanceLeaf(cursor, leftSiblingCursor, structurePropagation, keyCount, leftSiblingKeyCount);
                }
                this.mergeFromLeftSiblingLeaf(cursor, leftSiblingCursor, structurePropagation, keyCount, leftSiblingKeyCount, stableGeneration, unstableGeneration);
            }
        } else if (TreeNode.isNode(rightSibling)) {
            try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(rightSibling));){
                rightSiblingCursor.next();
                int rightSiblingKeyCount = TreeNode.keyCount(rightSiblingCursor);
                if (keyCount + rightSiblingKeyCount <= this.bTreeNode.leafMaxKeyCount()) {
                    this.createSuccessorIfNeeded(rightSiblingCursor, structurePropagation, StructurePropagation.UPDATE_RIGHT_CHILD, stableGeneration, unstableGeneration);
                    this.mergeToRightSiblingLeaf(cursor, rightSiblingCursor, structurePropagation, keyCount, rightSiblingKeyCount, stableGeneration, unstableGeneration);
                }
            }
        }
    }

    private void connectLeftAndRightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) throws IOException {
        long currentId = cursor.getCurrentPageId();
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling", leftSibling);
            TreeNode.setRightSibling(cursor, rightSibling, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling", rightSibling);
            TreeNode.setLeftSibling(cursor, leftSibling, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "back to origin after repointing siblings", currentId);
    }

    private void mergeToRightSiblingLeaf(PageCursor cursor, PageCursor rightSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.merge(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount, stableGeneration, unstableGeneration);
        structurePropagation.hasMidChildUpdate = true;
        structurePropagation.midChild = rightSiblingCursor.getCurrentPageId();
        structurePropagation.hasRightKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
        this.bTreeNode.keyAt(rightSiblingCursor, structurePropagation.rightKey, rightSiblingKeyCount - 1);
    }

    private void mergeFromLeftSiblingLeaf(PageCursor cursor, PageCursor leftSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int leftSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.merge(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, stableGeneration, unstableGeneration);
        structurePropagation.hasLeftChildUpdate = true;
        structurePropagation.leftChild = cursor.getCurrentPageId();
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
        this.bTreeNode.keyAt(cursor, structurePropagation.leftKey, 0);
    }

    private void merge(PageCursor leftSiblingCursor, int leftSiblingKeyCount, PageCursor rightSiblingCursor, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.insertKeySlotsAt(rightSiblingCursor, 0, leftSiblingKeyCount, rightSiblingKeyCount);
        this.bTreeNode.insertValueSlotsAt(rightSiblingCursor, 0, leftSiblingKeyCount, rightSiblingKeyCount);
        this.copyKeysAndValues(leftSiblingCursor, 0, rightSiblingCursor, 0, leftSiblingKeyCount);
        TreeNode.setKeyCount(rightSiblingCursor, rightSiblingKeyCount + leftSiblingKeyCount);
        TreeNode.setSuccessor(leftSiblingCursor, rightSiblingCursor.getCurrentPageId(), stableGeneration, unstableGeneration);
        this.connectLeftAndRightSibling(leftSiblingCursor, stableGeneration, unstableGeneration);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, leftSiblingCursor.getCurrentPageId());
    }

    private void rebalanceLeaf(PageCursor cursor, PageCursor leftSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int leftSiblingKeyCount) {
        int totalKeyCount = keyCount + leftSiblingKeyCount;
        int keyCountInLeftSiblingAfterRebalance = totalKeyCount / 2;
        int numberOfKeysToMove = leftSiblingKeyCount - keyCountInLeftSiblingAfterRebalance;
        this.bTreeNode.insertKeySlotsAt(cursor, 0, numberOfKeysToMove, keyCount);
        this.bTreeNode.insertValueSlotsAt(cursor, 0, numberOfKeysToMove, keyCount);
        this.copyKeysAndValues(leftSiblingCursor, keyCountInLeftSiblingAfterRebalance, cursor, 0, numberOfKeysToMove);
        TreeNode.setKeyCount(cursor, keyCount + numberOfKeysToMove);
        TreeNode.setKeyCount(leftSiblingCursor, leftSiblingKeyCount - numberOfKeysToMove);
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.REPLACE;
        this.bTreeNode.keyAt(cursor, structurePropagation.leftKey, 0);
    }

    private int simplyRemoveFromLeaf(PageCursor cursor, VALUE into, int keyCount, int pos) {
        this.bTreeNode.removeKeyAt(cursor, pos, keyCount);
        this.bTreeNode.valueAt(cursor, into, pos);
        this.bTreeNode.removeValueAt(cursor, pos, keyCount);
        int newKeyCount = keyCount - 1;
        TreeNode.setKeyCount(cursor, newKeyCount);
        return newKeyCount;
    }

    private void createSuccessorIfNeeded(PageCursor cursor, StructurePropagation<KEY> structurePropagation, StructurePropagation.StructureUpdate structureUpdate, long stableGeneration, long unstableGeneration) throws IOException {
        long oldId = cursor.getCurrentPageId();
        long nodeGeneration = TreeNode.generation(cursor);
        if (nodeGeneration == unstableGeneration) {
            return;
        }
        long successorId = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        try (PageCursor successorCursor = cursor.openLinkedCursor(successorId);){
            TreeNode.goTo(successorCursor, "successor", successorId);
            cursor.copyTo(0, successorCursor, 0, cursor.getCurrentPageSize());
            TreeNode.setGeneration(successorCursor, unstableGeneration);
            TreeNode.setSuccessor(successorCursor, 0L, stableGeneration, unstableGeneration);
        }
        TreeNode.setSuccessor(cursor, successorId, stableGeneration, unstableGeneration);
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling in split", leftSibling);
            TreeNode.setRightSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling in split", rightSibling);
            TreeNode.setLeftSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "successor", successorId);
        structureUpdate.update(structurePropagation, successorId);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, oldId);
    }

    private static class Level<KEY> {
        private final Comparator<KEY> layout;
        private long treeNodeId;
        private int childPos;
        private final KEY lower;
        private boolean lowerIsOpenEnded;
        private final KEY upper;
        private boolean upperIsOpenEnded;

        Level(Layout<KEY, ?> layout) {
            this.layout = layout;
            this.lower = layout.newKey();
            this.upper = layout.newKey();
        }

        boolean covers(KEY key) {
            boolean insideLower = this.lowerIsOpenEnded || this.layout.compare(key, this.lower) >= 0;
            boolean insideHigher = this.upperIsOpenEnded || this.layout.compare(key, this.upper) < 0;
            return insideLower && insideHigher;
        }
    }
}

