/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ftp.StructrFtpFile;
import org.structr.files.ftp.StructrFtpUser;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public abstract class AbstractStructrFtpFile
implements FtpFile {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractStructrFtpFile.class.getName());
    protected AbstractFile structrFile;
    protected SecurityContext securityContext = null;
    protected StructrFtpUser owner;
    protected String newPath = "/";

    public AbstractStructrFtpFile(SecurityContext securityContext, AbstractFile file) {
        this.structrFile = file;
        this.securityContext = securityContext;
    }

    public AbstractStructrFtpFile(String path, StructrFtpUser user) {
        this.newPath = path;
        this.owner = user;
        this.securityContext = user.getStructrUser().getSecurityContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAbsolutePath() {
        if (this.structrFile == null) {
            return this.newPath;
        }
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String path = FileHelper.getFolderPath((AbstractFile)this.structrFile);
            tx.success();
            String string = path;
            return string;
        }
        catch (FrameworkException fex) {
            logger.error("Error in getName() of abstract ftp file", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String name = null;
            if (!"/".equals(this.newPath)) {
                name = this.newPath.contains("/") ? StringUtils.substringAfterLast((String)this.newPath, (String)"/") : this.newPath;
            } else if (this.structrFile != null) {
                name = (String)this.structrFile.getProperty((PropertyKey)FileBase.name);
            }
            tx.success();
            if (name != null) {
                String string = name;
                return string;
            }
            if (this.structrFile == null) return null;
            String string = this.structrFile.getUuid();
            return string;
        }
        catch (FrameworkException fex) {
            logger.error("Error in getName() of abstract ftp file", (Throwable)fex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHidden() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            boolean hidden = (Boolean)this.structrFile.getProperty((PropertyKey)FileBase.hidden);
            tx.success();
            boolean bl = hidden;
            return bl;
        }
        catch (FrameworkException fex) {
            logger.error("Error in isHidden() of abstract ftp file", (Throwable)fex);
            return true;
        }
    }

    public boolean doesExist() {
        return this.structrFile != null;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOwnerName() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal owner = this.getOwner();
            String name = "";
            if (owner != null) {
                name = (String)owner.getProperty((PropertyKey)AbstractUser.name);
            }
            tx.success();
            String string = name;
            return string;
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting owner name of " + this, (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getGroupName() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            List parents;
            Principal owner = this.getOwner();
            String name = "";
            if (owner != null && !(parents = owner.getParents()).isEmpty()) {
                name = (String)((Principal)parents.get(0)).getProperty((PropertyKey)AbstractNode.name);
            }
            tx.success();
            String string = name;
            return string;
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting group name of " + this, (Throwable)fex);
            return "";
        }
    }

    public int getLinkCount() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastModified() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Date date = (Date)this.structrFile.getProperty((PropertyKey)AbstractFile.lastModifiedDate);
            tx.success();
            long l = date.getTime();
            return l;
        }
        catch (FrameworkException fex) {
            logger.error("Error while last modified date of " + this, (Throwable)fex);
            return 0L;
        }
    }

    public boolean setLastModified(long l) {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.structrFile.setProperty((PropertyKey)AbstractFile.lastModifiedDate, (Object)new Date(l));
            tx.success();
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    public boolean delete() {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = StructrApp.getInstance().tx();){
            app.delete((NodeInterface)this.structrFile);
            tx.success();
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean move(FtpFile target) {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            logger.info("move()");
            AbstractStructrFtpFile targetFile = (AbstractStructrFtpFile)target;
            String path = targetFile instanceof StructrFtpFile ? "/" : targetFile.getAbsolutePath();
            try {
                if (path.contains("/")) {
                    String newParentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                    AbstractFile newParent = FileHelper.getFileByAbsolutePath((SecurityContext)this.securityContext, (String)newParentPath);
                    if (newParent != null && newParent instanceof Folder) {
                        Folder newParentFolder = (Folder)newParent;
                        this.structrFile.setProperty((PropertyKey)AbstractFile.parent, (Object)newParentFolder);
                    } else {
                        this.structrFile.setProperty((PropertyKey)AbstractFile.parent, null);
                    }
                }
                if (!"/".equals(path)) {
                    String newName = path.contains("/") ? StringUtils.substringAfterLast((String)path, (String)"/") : path;
                    this.structrFile.setProperty((PropertyKey)AbstractNode.name, (Object)newName);
                }
            }
            catch (FrameworkException ex) {
                logger.error("Could not move ftp file", (Throwable)ex);
                boolean bl2 = false;
                if (tx == null) return bl2;
                if (throwable == null) {
                    tx.close();
                    return bl2;
                }
                try {
                    tx.close();
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return bl2;
                }
            }
            tx.success();
            boolean bl = true;
            return bl;
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Principal getOwner() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal owner = (Principal)this.structrFile.getProperty((PropertyKey)FileBase.owner);
            tx.success();
            Principal principal = owner;
            return principal;
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting owner of " + this, (Throwable)fex);
            return null;
        }
    }

    protected AbstractFile getStructrFile() {
        return this.structrFile;
    }
}

