/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ftp.AbstractStructrFtpFile;
import org.structr.files.ftp.StructrFtpFile;
import org.structr.web.common.RenderContext;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.importer.Importer;

public class FtpFilePageWrapper
implements FtpFile {
    private static final Logger logger = LoggerFactory.getLogger((String)FtpFilePageWrapper.class.getName());
    private Page page = null;

    public FtpFilePageWrapper(Page page) {
        this.page = page;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAbsolutePath() {
        try (Tx tx = StructrApp.getInstance().tx();){
            String path = this.page.getPath();
            tx.success();
            String string = path;
            return string;
        }
        catch (FrameworkException fex) {
            logger.error("Error in getPath() of abstract ftp file", (Throwable)fex);
            return null;
        }
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public boolean doesExist() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Principal getOwner() {
        try (Tx tx = StructrApp.getInstance().tx();){
            Principal owner = (Principal)this.page.getProperty((PropertyKey)FileBase.owner);
            tx.success();
            Principal principal = owner;
            return principal;
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting owner of " + this, (Throwable)fex);
            return null;
        }
    }

    public String getOwnerName() {
        String name = "";
        try (Tx tx = StructrApp.getInstance().tx();){
            Principal owner = this.getOwner();
            if (owner != null) {
                name = (String)owner.getProperty((PropertyKey)AbstractUser.name);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting owner name of " + this, (Throwable)fex);
        }
        return name;
    }

    public String getGroupName() {
        String name = "";
        try (Tx tx = StructrApp.getInstance().tx();){
            List parents;
            Principal owner = this.getOwner();
            if (owner != null && !(parents = owner.getParents()).isEmpty()) {
                name = (String)((Principal)parents.get(0)).getProperty((PropertyKey)AbstractNode.name);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error while getting group name of " + this, (Throwable)fex);
        }
        return name;
    }

    public int getLinkCount() {
        return 1;
    }

    public long getLastModified() {
        long lastModified = 0L;
        try (Tx tx = StructrApp.getInstance().tx();){
            lastModified = ((Date)this.page.getProperty((PropertyKey)GraphObject.lastModifiedDate)).getTime();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error while last modified date of " + this, (Throwable)fex);
        }
        return lastModified;
    }

    public boolean setLastModified(long time) {
        try (Tx tx = StructrApp.getInstance().tx();){
            this.page.setProperty((PropertyKey)GraphObject.lastModifiedDate, (Object)new Date(time));
            tx.success();
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    public long getSize() {
        long size = 0L;
        try (Tx tx = StructrApp.getInstance().tx();){
            size = this.page.getContent(RenderContext.EditMode.RAW).length();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error while last modified date of " + this, (Throwable)fex);
        }
        return size;
    }

    public String getName() {
        String name = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            name = (String)this.page.getProperty((PropertyKey)AbstractNode.name);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error in getName() of page", (Throwable)fex);
        }
        return name;
    }

    public boolean isHidden() {
        boolean hidden = true;
        try (Tx tx = StructrApp.getInstance().tx();){
            hidden = (Boolean)this.page.getProperty((PropertyKey)Page.hidden);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Error in isHidden() of page", (Throwable)fex);
        }
        return hidden;
    }

    public boolean mkdir() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getPhysicalFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean delete() {
        App app = StructrApp.getInstance();
        try (Tx tx = StructrApp.getInstance().tx();){
            app.delete((NodeInterface)this.page);
            tx.success();
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean move(FtpFile target) {
        try (Tx tx = StructrApp.getInstance().tx();){
            logger.info("move()");
            AbstractStructrFtpFile targetFile = (AbstractStructrFtpFile)target;
            String path = targetFile instanceof StructrFtpFile ? "/" : targetFile.getAbsolutePath();
            try {
                if (!"/".equals(path)) {
                    String newName = path.contains("/") ? StringUtils.substringAfterLast((String)path, (String)"/") : path;
                    this.page.setProperty((PropertyKey)AbstractNode.name, (Object)newName);
                }
            }
            catch (FrameworkException ex) {
                logger.error("Could not move ftp file", (Throwable)ex);
                boolean bl2 = false;
                if (tx == null) return bl2;
                if (throwable == null) {
                    tx.close();
                    return bl2;
                }
                try {
                    tx.close();
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return bl2;
                }
            }
            tx.success();
            boolean bl = true;
            return bl;
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
            return false;
        }
    }

    public List<FtpFile> listFiles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        final Page origPage = this.page;
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                String source = this.toString();
                App app = StructrApp.getInstance();
                try (Tx tx = app.tx();){
                    Page modifiedPage = Importer.parsePageFromSource((SecurityContext)FtpFilePageWrapper.this.page.getSecurityContext(), (String)source, (String)"__FTP_Temporary_Page__");
                    List changeSet = Importer.diffNodes((DOMNode)origPage, (DOMNode)modifiedPage);
                    for (InvertibleModificationOperation op : changeSet) {
                        op.apply(app, origPage, modifiedPage);
                    }
                    app.delete((NodeInterface)modifiedPage);
                    tx.success();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
                super.flush();
            }
        };
        return out;
    }

    public InputStream createInputStream(long offset) throws IOException {
        ByteArrayInputStream bis = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            bis = new ByteArrayInputStream(this.page.getContent(RenderContext.EditMode.RAW).getBytes("UTF-8"));
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return bis;
    }
}

