/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.files.ftp.StructrFileSystemView;

public class StructrFileSystemFactory
implements FileSystemFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFileSystemFactory.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileSystemView createFileSystemView(User user) throws FtpException {
        try (Tx tx = StructrApp.getInstance().tx();){
            StructrFileSystemView fileSystemView = new StructrFileSystemView(user);
            logger.debug("Created Structr File System View [user, homeDir, workingDir]: {}, {}, {}", new Object[]{user.getName(), fileSystemView.getHomeDirectory().getAbsolutePath(), fileSystemView.getWorkingDirectory().getAbsolutePath()});
            tx.success();
            StructrFileSystemView structrFileSystemView = fileSystemView;
            return structrFileSystemView;
        }
        catch (FrameworkException fex) {
            logger.error("Could not create file system view for user {}", (Object)user);
            return null;
        }
    }
}

