/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.files.ftp.AbstractStructrFtpFile;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;

public class StructrFtpFile
extends AbstractStructrFtpFile {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFtpFile.class.getName());

    public StructrFtpFile(SecurityContext securityContext, FileBase file) {
        super(securityContext, (AbstractFile)file);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSize() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Long size = ((FileBase)this.structrFile).getSize();
            tx.success();
            long l = size == null ? 0L : size;
            return l;
        }
        catch (FrameworkException frameworkException) {
            return 0L;
        }
    }

    public boolean mkdir() {
        logger.info("mkdir()");
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputStream createOutputStream(long l) throws IOException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            FileOutputStream outputStream = ((FileBase)this.structrFile).getOutputStream();
            tx.success();
            FileOutputStream fileOutputStream = outputStream;
            return fileOutputStream;
        }
        catch (FrameworkException fex) {
            logger.error(null, (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream createInputStream(long l) throws IOException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            InputStream inputStream2 = ((FileBase)this.structrFile).getInputStream();
            tx.success();
            InputStream inputStream = inputStream2;
            return inputStream;
        }
        catch (FrameworkException fex) {
            logger.error(null, (Throwable)fex);
            return null;
        }
    }

    public List<FtpFile> listFiles() {
        logger.info("listFiles()");
        return null;
    }

    public Object getPhysicalFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

