/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.util.ArrayList;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ftp.StructrFtpUser;
import org.structr.rest.auth.AuthHelper;
import org.structr.web.entity.User;

public class StructrUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrUserManager.class.getName());
    private SecurityContext securityContext = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.apache.ftpserver.ftplet.User getUserByName(String userName) throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            User structrUser = this.getStructrUser(userName);
            tx.success();
            if (structrUser != null) {
                StructrFtpUser structrFtpUser = new StructrFtpUser(this.securityContext, structrUser);
                return structrFtpUser;
            }
            org.apache.ftpserver.ftplet.User user = null;
            return user;
        }
        catch (FrameworkException fex) {
            logger.error("Unable to get user by its name", (Throwable)fex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAllUserNames() throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            ArrayList<Object> userNames = new ArrayList<Object>();
            Result result = Result.EMPTY_RESULT;
            try {
                result = StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(Principal.class).getResult();
            }
            catch (FrameworkException ex) {
                logger.warn("Error while searching for principal", (Throwable)ex);
            }
            if (!result.isEmpty()) {
                for (Principal p : result.getResults()) {
                    userNames.add(p.getProperty((PropertyKey)AbstractUser.name));
                }
            }
            tx.success();
            String[] stringArray = userNames.toArray(new String[userNames.size()]);
            return stringArray;
        }
        catch (FrameworkException fex) {
            logger.error("Unable to get user by its name", (Throwable)fex);
            return null;
        }
    }

    public void delete(String string) throws FtpException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void save(org.apache.ftpserver.ftplet.User user) throws FtpException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesExist(String string) throws FtpException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            boolean exists = this.getStructrUser(string) != null;
            tx.success();
            boolean bl = exists;
            return bl;
        }
        catch (FrameworkException fex) {
            logger.error("Unable to determine if user " + string + " exists", (Throwable)fex);
            return false;
        }
    }

    public org.apache.ftpserver.ftplet.User authenticate(Authentication auth) throws AuthenticationFailedException {
        logger.debug("Authentication: {}", (Object)auth);
        String userName = null;
        String password = null;
        if (auth instanceof UsernamePasswordAuthentication) {
            User user = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                UsernamePasswordAuthentication authentication = (UsernamePasswordAuthentication)auth;
                userName = authentication.getUsername();
                password = authentication.getPassword();
                user = (User)AuthHelper.getPrincipalForPassword((PropertyKey)AbstractUser.name, (String)userName, (String)password);
                this.securityContext = SecurityContext.getInstance((Principal)user, (AccessMode)AccessMode.Backend);
                tx.success();
            }
            catch (FrameworkException ex) {
                logger.warn("FTP authentication attempt failed with username {} and password {}", new Object[]{userName, password});
            }
            if (user != null) {
                return new StructrFtpUser(this.securityContext, user);
            }
        }
        throw new AuthenticationFailedException("No structr user found for credentials " + userName + "/" + password);
    }

    public String getAdminName() throws FtpException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAdmin(String string) throws FtpException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private User getStructrUser(String userName) {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            User user2 = (User)AuthHelper.getPrincipalForCredential((PropertyKey)AbstractUser.name, (Object)userName);
            tx.success();
            User user = user2;
            return user;
        }
        catch (FrameworkException fex) {
            logger.error("Unable to get user by its name", (Throwable)fex);
            return null;
        }
    }
}

