/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.files.ssh.TerminalEmulator;
import org.structr.files.ssh.TerminalHandler;

public abstract class AbstractTerminalEmulator
extends Thread
implements TerminalEmulator {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractTerminalEmulator.class.getName());
    protected final StringBuilder lineBuffer = new StringBuilder();
    protected TerminalHandler rootTerminalHandler = null;
    protected TerminalHandler terminalHandler = null;
    protected Reader reader = null;
    protected Writer writer = null;
    protected boolean running = false;
    protected boolean echo = true;
    protected int cursorPosition = 0;
    protected int lineLength = 0;
    protected int commandBufferIndex = 0;
    protected int tabCount = 0;

    public AbstractTerminalEmulator(InputStream in, OutputStream out, TerminalHandler rootTerminalHandler) {
        this.rootTerminalHandler = rootTerminalHandler;
        this.terminalHandler = rootTerminalHandler;
        this.reader = new InputStreamReader(in);
        this.writer = new OutputStreamWriter(out);
    }

    @Override
    public void stopEmulator() {
        this.running = false;
    }

    @Override
    public void setTerminalHandler(TerminalHandler handler) throws IOException {
        this.terminalHandler = handler;
    }

    @Override
    public void restoreRootTerminalHandler() throws IOException {
        this.terminalHandler = this.rootTerminalHandler;
        this.setEcho(true);
    }

    @Override
    public void handleCursorUp() throws IOException {
        List<String> commandHistory = this.terminalHandler.getCommandHistory();
        if (commandHistory != null && this.echo) {
            int commandBufferSize = commandHistory.size();
            if (this.commandBufferIndex >= 0 && this.commandBufferIndex < commandBufferSize) {
                this.displaySelectedCommand(commandHistory.get(commandBufferSize - this.commandBufferIndex - 1));
                if (this.commandBufferIndex < commandBufferSize - 1) {
                    ++this.commandBufferIndex;
                }
            }
        }
    }

    @Override
    public void handleCursorDown() throws IOException {
        List<String> commandHistory = this.terminalHandler.getCommandHistory();
        if (commandHistory != null && this.echo) {
            if (this.commandBufferIndex > 0) {
                int commandBufferSize = commandHistory.size();
                if (this.commandBufferIndex >= 0 && this.commandBufferIndex <= commandBufferSize) {
                    --this.commandBufferIndex;
                    this.displaySelectedCommand(commandHistory.get(commandBufferSize - this.commandBufferIndex - 1));
                }
            } else {
                this.displaySelectedCommand("");
            }
        }
    }

    @Override
    public void handleCtrlKey(int key) throws IOException {
        switch (key) {
            case 3: {
                this.terminalHandler.handleCtrlC();
                break;
            }
            case 4: {
                if (this.lineLength != 0) break;
                this.terminalHandler.handleLogoutRequest();
            }
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                int c = this.reader.read();
                this.tabCount = c == 9 ? ++this.tabCount : 0;
                switch (c) {
                    case 9: {
                        this.handleTab(this.tabCount);
                        break;
                    }
                    case 13: {
                        this.handleNewline();
                        break;
                    }
                    case 27: {
                        c = this.reader.read();
                        block8 : switch (c) {
                            case 91: {
                                c = this.reader.read();
                                switch (c) {
                                    case 50: {
                                        c = this.reader.read();
                                        switch (c) {
                                            case 126: {
                                                this.handleInsert();
                                            }
                                        }
                                        break block8;
                                    }
                                    case 51: {
                                        c = this.reader.read();
                                        switch (c) {
                                            case 126: {
                                                this.handleDelete();
                                            }
                                        }
                                        break block8;
                                    }
                                    case 53: {
                                        c = this.reader.read();
                                        switch (c) {
                                            case 126: {
                                                this.handlePageUp();
                                            }
                                        }
                                        break block8;
                                    }
                                    case 54: {
                                        c = this.reader.read();
                                        switch (c) {
                                            case 126: {
                                                this.handlePageDown();
                                            }
                                        }
                                        break block8;
                                    }
                                    case 65: {
                                        this.handleCursorUp();
                                        break block8;
                                    }
                                    case 66: {
                                        this.handleCursorDown();
                                        break block8;
                                    }
                                    case 67: {
                                        this.handleCursorRight();
                                        break block8;
                                    }
                                    case 68: {
                                        this.handleCursorLeft();
                                        break block8;
                                    }
                                    case 70: {
                                        this.handleEnd();
                                        break block8;
                                    }
                                    case 72: {
                                        this.handleHome();
                                        break block8;
                                    }
                                    case 90: {
                                        this.handleShiftTab();
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 127: {
                        this.handleBackspace();
                        break;
                    }
                    default: {
                        if (c < 27) {
                            this.handleCtrlKey(c);
                            break;
                        }
                        this.handleCharacter(c);
                    }
                }
                this.writer.flush();
            }
            catch (Throwable t) {
                logger.warn("Exception", t);
                try {
                    this.writer.write(10);
                    this.writer.write(t.getMessage());
                    this.writer.write(10);
                }
                catch (Throwable t2) {
                    logger.warn("", t);
                }
            }
        }
        this.terminalHandler.handleExit();
    }

    public void print(Object ... text) throws IOException {
        if (text != null) {
            for (Object o : text) {
                if (o != null) {
                    this.writer.write(o.toString().replaceAll("\n", "\r\n"));
                    continue;
                }
                this.writer.write("null");
            }
        }
        this.writer.flush();
    }

    public void println(Object ... text) throws IOException {
        this.print(text);
        this.println();
        this.writer.flush();
    }

    @Override
    public void clearLineBuffer() {
        this.lineBuffer.setLength(0);
        this.cursorPosition = 0;
        this.lineLength = 0;
    }

    @Override
    public StringBuilder getLineBuffer() {
        return this.lineBuffer;
    }

    @Override
    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void clearTabCount() {
        this.tabCount = 0;
    }

    protected void handleLineInternal(String line) throws IOException {
        this.terminalHandler.handleLine(line);
        this.commandBufferIndex = 0;
    }

    private void displaySelectedCommand(String selectedCommand) throws IOException {
        this.lineBuffer.setLength(0);
        this.lineBuffer.append(selectedCommand);
        this.lineLength = this.lineBuffer.length();
        int loopCount = this.cursorPosition;
        for (int i = 0; i < loopCount; ++i) {
            this.handleCursorLeft();
        }
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(75);
        this.print(selectedCommand);
        this.cursorPosition = this.lineLength;
    }
}

