/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.SingletonService;
import org.structr.api.service.StructrServices;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.console.Console;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrConsoleCommand;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.rest.auth.AuthHelper;

public class SSHService
implements SingletonService,
PasswordAuthenticator,
PublickeyAuthenticator,
FileSystemFactory,
Factory<Command>,
SftpEventListener,
CommandFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)SSHService.class.getName());
    private final ScpCommandFactory scp = new ScpCommandFactory.Builder().build();
    private SshServer server = null;
    private boolean running = false;
    private SecurityContext securityContext = null;
    private Tx currentTransaction = null;

    public void injectArguments(org.structr.api.service.Command command) {
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.info("Setting up SSH server..");
        this.server = SshServer.setUpDefaultServer();
        logger.info("Initializing host key generator..");
        SimpleGeneratorHostKeyProvider hostKeyProvider = new SimpleGeneratorHostKeyProvider(Paths.get("db/structr_hostkey", new String[0]));
        hostKeyProvider.setAlgorithm("RSA");
        logger.info("Configuring SSH server..");
        this.server.setKeyPairProvider((KeyPairProvider)hostKeyProvider);
        this.server.setPort(((Integer)Settings.SshPort.getValue()).intValue());
        this.server.setPasswordAuthenticator((PasswordAuthenticator)this);
        this.server.setPublickeyAuthenticator((PublickeyAuthenticator)this);
        this.server.setFileSystemFactory((FileSystemFactory)this);
        this.server.setSubsystemFactories(this.getSubsystems());
        this.server.setShellFactory((Factory)this);
        this.server.setCommandFactory((CommandFactory)this);
        logger.info("Starting SSH server on port {}", (Object)this.server.getPort());
        try {
            this.server.start();
            this.running = true;
            logger.info("Initialization complete.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.info("Initialization failed.");
        }
    }

    public void shutdown() {
        try {
            this.server.stop(true);
            this.running = false;
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void initialized() {
    }

    public String getName() {
        return "SSHService";
    }

    public boolean isRunning() {
        return this.server != null && this.running;
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "file-access";
    }

    public FileSystem createFileSystem(Session session) throws IOException {
        return new StructrFilesystem(this.securityContext);
    }

    public boolean authenticate(String username, String password, ServerSession session) {
        boolean isValid = false;
        Principal principal = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            principal = AuthHelper.getPrincipalForPassword((PropertyKey)AbstractNode.name, (String)username, (String)password);
            if (principal != null) {
                isValid = true;
                this.securityContext = SecurityContext.getInstance((Principal)principal, (AccessMode)AccessMode.Backend);
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
            isValid = false;
        }
        try {
            if (isValid) {
                session.setAuthenticated();
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        return isValid;
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        boolean isValid = false;
        if (key == null) {
            return isValid;
        }
        try (Tx tx = StructrApp.getInstance().tx();){
            Principal principal = (Principal)StructrApp.getInstance().nodeQuery(Principal.class).andName(username).getFirst();
            if (principal != null) {
                String[] pubKeysData;
                this.securityContext = SecurityContext.getInstance((Principal)principal, (AccessMode)AccessMode.Backend);
                String pubKeyData = (String)principal.getProperty((PropertyKey)Principal.publicKey);
                if (pubKeyData != null) {
                    PublicKey pubKey = PublicKeyEntry.parsePublicKeyEntry((String)pubKeyData).resolvePublicKey(PublicKeyEntryResolver.FAILING);
                    isValid = KeyUtils.compareKeys((PublicKey)pubKey, (PublicKey)key);
                }
                if ((pubKeysData = (String[])principal.getProperty((PropertyKey)Principal.publicKeys)) != null) {
                    for (String k : pubKeysData) {
                        PublicKey pubKey;
                        if (k == null || !KeyUtils.compareKeys((PublicKey)(pubKey = PublicKeyEntry.parsePublicKeyEntry((String)k).resolvePublicKey(PublicKeyEntryResolver.FAILING)), (PublicKey)key)) continue;
                        isValid = true;
                        break;
                    }
                }
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
            isValid = false;
        }
        try {
            if (isValid) {
                session.setAuthenticated();
            }
        }
        catch (IOException ex) {
            logger.error("Unable to authenticate session", (Throwable)ex);
        }
        return isValid;
    }

    public Command create() {
        return new StructrConsoleCommand(this.securityContext);
    }

    private void beginTransaction() {
        if (this.currentTransaction == null) {
            this.currentTransaction = StructrApp.getInstance((SecurityContext)this.securityContext).tx(true, false, false);
        }
    }

    private void endTransaction() {
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.success();
                this.currentTransaction.close();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
            finally {
                this.currentTransaction = null;
            }
        }
    }

    public void initialized(ServerSession session, int version) {
    }

    public void destroying(ServerSession session) {
    }

    public void open(ServerSession session, String remoteHandle, Handle localHandle) {
        this.beginTransaction();
    }

    public void read(ServerSession session, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries) {
    }

    public void read(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, int readLen) {
    }

    public void write(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) {
    }

    public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) {
    }

    public void blocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) {
    }

    public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) {
    }

    public void unblocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, Boolean result, Throwable thrown) {
    }

    public void close(ServerSession session, String remoteHandle, Handle localHandle) {
        this.endTransaction();
    }

    public void creating(ServerSession session, Path path, Map<String, ?> attrs) {
        this.beginTransaction();
    }

    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) {
        this.endTransaction();
    }

    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) {
        this.beginTransaction();
    }

    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) {
        this.endTransaction();
    }

    public void removing(ServerSession session, Path path) {
        this.beginTransaction();
    }

    public void removed(ServerSession session, Path path, Throwable thrown) {
        this.endTransaction();
    }

    public void linking(ServerSession session, Path source, Path target, boolean symLink) {
        this.beginTransaction();
    }

    public void linked(ServerSession session, Path source, Path target, boolean symLink, Throwable thrown) {
        this.endTransaction();
    }

    public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) {
    }

    public void modifiedAttributes(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) {
    }

    public Command createCommand(String command) {
        if (command.startsWith("scp ")) {
            return this.scp.createCommand(command);
        }
        if (command.startsWith("javascript ")) {
            return new StructrConsoleCommand(this.securityContext, Console.ConsoleMode.JavaScript, command.substring(11));
        }
        if (command.startsWith("structrscript ")) {
            return new StructrConsoleCommand(this.securityContext, Console.ConsoleMode.StructrScript, command.substring(14));
        }
        if (command.startsWith("cypher ")) {
            return new StructrConsoleCommand(this.securityContext, Console.ConsoleMode.Cypher, command.substring(7));
        }
        if (command.startsWith("admin ")) {
            return new StructrConsoleCommand(this.securityContext, Console.ConsoleMode.AdminShell, command.substring(6));
        }
        if (command.startsWith("rest ")) {
            return new StructrConsoleCommand(this.securityContext, Console.ConsoleMode.REST, command.substring(5));
        }
        throw new IllegalStateException("Unknown subsystem for command '" + command + "'");
    }

    private List<NamedFactory<Command>> getSubsystems() {
        LinkedList<NamedFactory<Command>> list = new LinkedList<NamedFactory<Command>>();
        SftpSubsystemFactory factory = new SftpSubsystemFactory();
        list.add((NamedFactory<Command>)factory);
        factory.addSftpEventListener((SftpEventListener)this);
        return list;
    }
}

