/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.files.ssh.StructrPosixFileAttributes;
import org.structr.files.ssh.StructrSSHFile;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class StructrSSHFileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSSHFileSystem.class.getName());
    private StructrSSHFile rootFolder = null;
    private Session session = null;
    private SecurityContext securityContext = null;

    public StructrSSHFileSystem(SecurityContext securityContext, Session session) {
        this.securityContext = securityContext;
        this.session = session;
        this.rootFolder = new StructrSSHFile(securityContext);
        this.rootFolder.setFileSystem(this);
    }

    @Override
    public FileSystemProvider provider() {
        logger.info("x");
        return new FileSystemProvider(){

            @Override
            public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
                logger.info("x");
                FileOutputStream os = null;
                FileBase actualFile = (FileBase)((StructrSSHFile)path).getActualFile();
                try (Tx tx = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext).tx();){
                    if (actualFile == null) {
                        actualFile = (FileBase)this.create(path);
                    }
                    if (actualFile != null) {
                        os = actualFile.getOutputStream();
                    }
                    tx.success();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                    throw new IOException(fex);
                }
                return os;
            }

            @Override
            public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
                logger.info("x");
                InputStream inputStream = null;
                try (Tx tx = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext).tx();){
                    FileBase fileNode = (FileBase)((StructrSSHFile)path).getActualFile();
                    inputStream = fileNode.getInputStream();
                    tx.success();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                    throw new IOException(fex);
                }
                return inputStream;
            }

            @Override
            public String getScheme() {
                logger.info("Method not implemented yet");
                return null;
            }

            @Override
            public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
                logger.info("Method not implemented yet");
                return null;
            }

            @Override
            public FileSystem getFileSystem(URI uri) {
                logger.info("Method not implemented yet");
                return null;
            }

            @Override
            public Path getPath(URI uri) {
                logger.info("Method not implemented yet");
                return null;
            }

            @Override
            public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
                logger.info("x");
                SeekableByteChannel channel = null;
                FileBase fileNode = (FileBase)((StructrSSHFile)path).getActualFile();
                if (fileNode != null) {
                    try (Tx tx = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext).tx();){
                        Path filePath = FileHelper.getPath((FileBase)fileNode);
                        channel = Files.newByteChannel(filePath, new OpenOption[0]);
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.error("", (Throwable)fex);
                        throw new IOException(fex);
                    }
                }
                return channel;
            }

            @Override
            public DirectoryStream<Path> newDirectoryStream(final Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
                logger.info("x");
                return new DirectoryStream(){
                    boolean closed = false;

                    @Override
                    public Iterator iterator() {
                        if (!this.closed) {
                            App app = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext);
                            LinkedList<StructrSSHFile> files = new LinkedList<StructrSSHFile>();
                            StructrSSHFile thisDir = (StructrSSHFile)dir;
                            try (Tx tx = app.tx();){
                                for (Folder folder : thisDir.getFolders()) {
                                    files.add(new StructrSSHFile(thisDir, folder.getName(), (AbstractFile)folder));
                                }
                                for (FileBase fileBase : thisDir.getFiles()) {
                                    files.add(new StructrSSHFile(thisDir, fileBase.getName(), (AbstractFile)fileBase));
                                }
                                tx.success();
                            }
                            catch (FrameworkException fex) {
                                logger.warn("", (Throwable)fex);
                            }
                            return files.iterator();
                        }
                        return Collections.emptyIterator();
                    }

                    @Override
                    public void close() throws IOException {
                        this.closed = true;
                    }
                };
            }

            @Override
            public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
                logger.info("x");
                StructrSSHFile parent = (StructrSSHFile)dir.getParent();
                App app = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext);
                String name = dir.getFileName().toString();
                try (Tx tx = app.tx();){
                    Folder folder = (Folder)app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)name), new NodeAttribute((PropertyKey)AbstractFile.parent, (Object)(parent != null ? parent.getActualFile() : null))});
                    ((StructrSSHFile)dir).setActualFile((AbstractFile)folder);
                    tx.success();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                    throw new IOException(fex);
                }
            }

            @Override
            public void delete(Path path) throws IOException {
                logger.info("Method not implemented yet");
            }

            @Override
            public void copy(Path source, Path target, CopyOption ... options) throws IOException {
                logger.info("Method not implemented yet");
            }

            @Override
            public void move(Path source, Path target, CopyOption ... options) throws IOException {
                logger.info("Method not implemented yet");
            }

            @Override
            public boolean isSameFile(Path path, Path path2) throws IOException {
                logger.info("x");
                return path != null && path.equals(path);
            }

            @Override
            public boolean isHidden(Path path) throws IOException {
                logger.info("Method not implemented yet");
                return false;
            }

            @Override
            public FileStore getFileStore(Path path) throws IOException {
                logger.info("Method not implemented yet");
                return null;
            }

            @Override
            public void checkAccess(Path path, AccessMode ... modes) throws IOException {
                logger.info("Checking access", new Object[]{path, modes});
            }

            @Override
            public <V extends FileAttributeView> V getFileAttributeView(final Path path, Class<V> type, LinkOption ... options) {
                logger.info("x");
                return (V)new PosixFileAttributeView(){

                    @Override
                    public String name() {
                        return "posix";
                    }

                    @Override
                    public PosixFileAttributes readAttributes() throws IOException {
                        return new StructrPosixFileAttributes((StructrSSHFile)path);
                    }

                    @Override
                    public void setPermissions(Set<PosixFilePermission> set) throws IOException {
                        logger.info("Method not implemented yet");
                    }

                    @Override
                    public void setGroup(GroupPrincipal gp) throws IOException {
                        logger.info("Method not implemented yet");
                    }

                    @Override
                    public void setTimes(FileTime ft, FileTime ft1, FileTime ft2) throws IOException {
                        logger.info("Method not implemented yet");
                    }

                    @Override
                    public UserPrincipal getOwner() throws IOException {
                        logger.info("Method not implemented yet");
                        return null;
                    }

                    @Override
                    public void setOwner(UserPrincipal up) throws IOException {
                        logger.info("Method not implemented yet");
                    }
                };
            }

            @Override
            public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
                logger.info("x");
                if (path != null && path instanceof StructrSSHFile) {
                    StructrSSHFile sshFile = (StructrSSHFile)path;
                    if (sshFile.getActualFile() == null) {
                        throw new NoSuchFileException("SSH file doesn't exist");
                    }
                    StructrPosixFileAttributes attrs = new StructrPosixFileAttributes((StructrSSHFile)path);
                    return (A)attrs;
                }
                throw new IOException("Unable to read attributes: Path is null");
            }

            @Override
            public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
                return Collections.EMPTY_MAP;
            }

            @Override
            public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
                logger.info("Method not implemented yet");
            }

            private AbstractFile create(Path path) throws IOException {
                logger.info("x");
                StructrSSHFile parent = (StructrSSHFile)path.getParent();
                AbstractFile newFile = null;
                App app = StructrApp.getInstance((SecurityContext)StructrSSHFileSystem.this.securityContext);
                try (Tx tx = app.tx();){
                    String fileName = path.getFileName().toString();
                    Folder parentFolder = (Folder)parent.getActualFile();
                    newFile = (AbstractFile)app.create(File.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)fileName), new NodeAttribute((PropertyKey)AbstractFile.parent, (Object)parentFolder)});
                    tx.success();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                    throw new IOException(fex);
                }
                return newFile;
            }
        };
    }

    @Override
    public void close() throws IOException {
        logger.info("x");
    }

    @Override
    public boolean isOpen() {
        logger.info("x");
        return true;
    }

    @Override
    public boolean isReadOnly() {
        logger.info("x");
        return false;
    }

    @Override
    public String getSeparator() {
        logger.info("x");
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        logger.info("x");
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(this.rootFolder);
        return paths;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        logger.info("x");
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        logger.info("x");
        HashSet<String> views = new HashSet<String>();
        views.add("posix");
        return views;
    }

    @Override
    public Path getPath(String string, String ... strings) {
        logger.info("x");
        if ("/".equals(string)) {
            return this.rootFolder;
        }
        return this.rootFolder.findFile(string);
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        logger.info("Method not implemented yet");
        return null;
    }
}

