/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.TerminalEmulator;
import org.structr.files.ssh.TerminalHandler;
import org.structr.files.ssh.XTermTerminalEmulator;
import org.structr.files.ssh.shell.CatCommand;
import org.structr.files.ssh.shell.CdCommand;
import org.structr.files.ssh.shell.LogoutCommand;
import org.structr.files.ssh.shell.LsCommand;
import org.structr.files.ssh.shell.MkdirCommand;
import org.structr.files.ssh.shell.PasswordCommand;
import org.structr.files.ssh.shell.ShellCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;

public class StructrShellCommand
implements Command,
SignalListener,
TerminalHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrShellCommand.class.getName());
    private static final Map<String, Class<? extends ShellCommand>> commands = new LinkedHashMap<String, Class<? extends ShellCommand>>();
    private final List<String> commandHistory = new LinkedList<String>();
    private Folder currentFolder = null;
    private TerminalEmulator term = null;
    private ExitCallback callback = null;
    private InputStream in = null;
    private OutputStream out = null;
    private OutputStream err = null;
    private User user = null;

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        env.addSignalListener((SignalListener)this);
        String userName = (String)env.getEnv().get("USER");
        if (userName != null) {
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                this.user = (User)app.nodeQuery(User.class).andName(userName).getFirst();
                if (this.user != null && ((Boolean)Settings.FilesystemEnabled.getValue()).booleanValue()) {
                    this.currentFolder = (Folder)this.user.getProperty((PropertyKey)User.homeDirectory);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        } else {
            logger.warn("Cannot start Structr shell, no username set!");
            return;
        }
        if (this.isInteractive()) {
            if (this.user == null) {
                logger.warn("Cannot start Structr shell, user not found for name {}!", (Object)userName);
                return;
            }
            String terminalType = (String)env.getEnv().get("TERM");
            if (terminalType != null) {
                switch (terminalType) {
                    case "xterm": 
                    case "vt100": 
                    case "vt220": {
                        this.term = new XTermTerminalEmulator(this.in, this.out, this);
                        break;
                    }
                    default: {
                        logger.warn("Unsupported terminal type {}, aborting.", (Object)terminalType);
                    }
                }
                logger.warn("No terminal type provided, aborting.", (Object)terminalType);
            }
            if (this.term != null) {
                this.term.start();
                this.term.print(new Object[]{"Welcome to "});
                this.term.setBold(true);
                this.term.print(new Object[]{"Structr"});
                this.term.print(new Object[]{" 2.0"});
                this.term.setBold(false);
                this.term.println();
                this.displayPrompt();
            } else {
                this.callback.onExit(1);
            }
        } else {
            this.term = new XTermTerminalEmulator(this.in, this.out, this);
        }
    }

    public void destroy() {
        if (this.term != null) {
            this.term.stopEmulator();
        }
    }

    public void signal(Signal signal) {
        logger.info("Received signal {}", (Object)signal.name());
    }

    @Override
    public void handleLine(String line) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)line)) {
            ShellCommand cmd = this.getCommandForLine(line);
            if (cmd != null) {
                cmd.setCommand(line);
                cmd.setUser(this.user);
                cmd.setTerminalEmulator(this.term);
                cmd.execute(this);
            }
            this.commandHistory.add(line);
        }
    }

    @Override
    public void handleExit() {
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    public String getPrompt() {
        App app = StructrApp.getInstance();
        StringBuilder buf = new StringBuilder();
        try (Tx tx = app.tx();){
            buf.append(this.user.getName());
            buf.append("@structr:");
            if (this.currentFolder != null) {
                String homeFolderPath;
                String folderPart = (String)this.currentFolder.getProperty((PropertyKey)AbstractFile.path);
                Folder homeFolder = (Folder)this.user.getProperty((PropertyKey)User.homeDirectory);
                if (homeFolder != null && folderPart.startsWith(homeFolderPath = (String)homeFolder.getProperty((PropertyKey)AbstractFile.path))) {
                    folderPart = "~" + folderPart.substring(homeFolderPath.length());
                }
                buf.append(folderPart);
            } else {
                buf.append("/");
            }
            buf.append(this.user.isAdmin() ? "#" : "$");
            buf.append(" ");
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return buf.toString();
    }

    public Folder getCurrentFolder() {
        return this.currentFolder;
    }

    public void setCurrentFolder(Folder folder) {
        this.currentFolder = folder;
    }

    public Folder findRelativeFolder(Folder baseFolder, String path) throws FrameworkException {
        App app = StructrApp.getInstance();
        Folder folder = baseFolder;
        boolean found = false;
        for (String part : path.split("[/]+")) {
            if (folder == null) {
                folder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)Folder.name, (Object)part).getFirst();
                continue;
            }
            for (Folder child : (List)folder.getProperty((PropertyKey)Folder.folders)) {
                if (!part.equals(child.getName())) continue;
                folder = child;
                found = true;
            }
            if (found) continue;
            return null;
        }
        return folder;
    }

    public boolean isAllowed(AbstractFile file, Permission permission, boolean explicit) {
        if (file == null) {
            return false;
        }
        SecurityContext securityContext = SecurityContext.getInstance((Principal)this.user, (AccessMode)AccessMode.Backend);
        if (Permission.read.equals(permission) && !explicit) {
            return file.isVisibleToAuthenticatedUsers() || file.isVisibleToPublicUsers() || file.isGranted(permission, securityContext);
        }
        return file.isGranted(permission, securityContext);
    }

    private ShellCommand getCommandForLine(String line) {
        int pos = line.indexOf(" ");
        String commandString = pos > 0 ? line.substring(0, pos) : line;
        Class<? extends ShellCommand> clazz = commands.get(commandString);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return null;
    }

    @Override
    public List<String> getCommandHistory() {
        return this.commandHistory;
    }

    @Override
    public void displayPrompt() throws IOException {
        this.term.print(new Object[]{this.getPrompt()});
    }

    @Override
    public void handleLogoutRequest() throws IOException {
        this.term.println(new Object[]{"logout"});
        this.term.stopEmulator();
    }

    @Override
    public void handleCtrlC() throws IOException {
        this.term.print(new Object[]{"^C"});
        this.term.clearLineBuffer();
        this.term.handleNewline();
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void handleShiftTab() throws IOException {
    }

    @Override
    public void handleTab(int tabCount) throws IOException {
        ShellCommand cmd;
        String line = this.term.getLineBuffer().toString();
        if (StringUtils.isNotBlank((CharSequence)line) && (cmd = this.getCommandForLine(line)) != null) {
            cmd.setUser(this.user);
            cmd.setTerminalEmulator(this.term);
            cmd.handleTabCompletion(this, line, tabCount);
        }
    }

    public boolean isInteractive() {
        return true;
    }

    public void flush() throws IOException {
        if (this.term != null) {
            this.term.flush();
        }
    }

    static {
        commands.put("cat", CatCommand.class);
        commands.put("cd", CdCommand.class);
        commands.put("exit", LogoutCommand.class);
        commands.put("logout", LogoutCommand.class);
        commands.put("ls", LsCommand.class);
        commands.put("mkdir", MkdirCommand.class);
        commands.put("passwd", PasswordCommand.class);
    }
}

