/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Group;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;

public class StructrFileAttributes
implements PosixFileAttributes,
DosFileAttributes,
PosixFileAttributeView {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFileAttributes.class.getName());
    public static final Set<String> SUPPORTED_VIEWS = new LinkedHashSet<String>(Arrays.asList("owner", "dos", "basic", "posix", "permissions"));
    private SecurityContext securityContext = null;
    private AbstractFile file = null;

    public StructrFileAttributes(SecurityContext securityContext, AbstractFile file) {
        this.securityContext = securityContext;
        this.file = file;
    }

    @Override
    public UserPrincipal owner() {
        if (this.file == null) {
            return null;
        }
        UserPrincipal owner = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal fileOwner = this.file.getOwnerNode();
            owner = fileOwner == null ? () -> ((Principal)this.securityContext.getUser(false)).getName() : () -> ((Principal)fileOwner).getName();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return owner;
    }

    @Override
    public GroupPrincipal group() {
        if (this.file == null) {
            return null;
        }
        LinkedList groups = new LinkedList();
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal owner = this.file.getOwnerNode();
            if (owner != null) {
                groups.addAll((Collection)owner.getProperty((PropertyKey)User.groups));
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return groups.size() > 0 ? () -> ((Group)((Group)groups.get(0))).getName() : null;
    }

    @Override
    public FileTime lastModifiedTime() {
        if (this.file == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Date date = this.file.getLastModifiedDate();
            if (date != null) {
                time = FileTime.fromMillis(date.getTime());
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastModifiedTime();
    }

    @Override
    public FileTime creationTime() {
        if (this.file == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Date date = this.file.getCreatedDate();
            if (date != null) {
                time = FileTime.fromMillis(date.getTime());
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public boolean isRegularFile() {
        if (this.file == null) {
            return false;
        }
        boolean isRegularFile = false;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            isRegularFile = (Boolean)this.file.getProperty((PropertyKey)FileBase.isFile);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return isRegularFile;
    }

    @Override
    public boolean isDirectory() {
        if (this.file == null) {
            return false;
        }
        boolean isDirectory = false;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            isDirectory = (Boolean)this.file.getProperty((PropertyKey)Folder.isFolder);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        if (this.file == null) {
            return 0L;
        }
        long size = 0L;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Number s = (Number)this.file.getProperty((PropertyKey)FileBase.size);
            if (s != null) {
                size = s.longValue();
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return size;
    }

    @Override
    public Object fileKey() {
        if (this.file == null) {
            return null;
        }
        String uuid = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            uuid = this.file.getUuid();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return uuid;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        if (this.file != null) {
            if (this.file instanceof Folder) {
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
            }
            try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
                if (this.file.isVisibleToPublicUsers()) {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                    permissions.add(PosixFilePermission.OTHERS_WRITE);
                    if (this.file instanceof Folder) {
                        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                    }
                }
                if (this.file.isVisibleToAuthenticatedUsers()) {
                    permissions.add(PosixFilePermission.GROUP_READ);
                    permissions.add(PosixFilePermission.GROUP_WRITE);
                    if (this.file instanceof Folder) {
                        permissions.add(PosixFilePermission.GROUP_EXECUTE);
                    }
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.error("", (Throwable)fex);
            }
        }
        return permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = filter.substring(0, filter.indexOf(":"));
        GroupPrincipal group = this.group();
        UserPrincipal owner = this.owner();
        if ("dos".equals(prefix)) {
            map.put("hidden", this.isHidden());
            map.put("archive", this.isArchive());
            map.put("system", this.isSystem());
            map.put("readonly", this.isReadOnly());
        }
        if (!"owner".equals(prefix)) {
            map.put("lastModifiedTime", this.lastModifiedTime());
            map.put("lastAccessTime", this.lastAccessTime());
            map.put("creationTime", this.creationTime());
            map.put("size", this.size());
            map.put("isRegularFile", this.isRegularFile());
            map.put("isDirectory", this.isDirectory());
            map.put("isSymbolicLink", this.isSymbolicLink());
            map.put("isOther", this.isOther());
            map.put("fileKey", this.fileKey());
        }
        if ("posix".equals(prefix)) {
            map.put("permissions", this.permissions());
            if (group != null) {
                map.put("group", group.getName());
            }
            if (owner != null) {
                map.put("owner", owner.getName());
                if (group == null) {
                    map.put("group", owner.getName());
                }
            }
        }
        if ("permissions".equals(prefix)) {
            map.put("permissions", this.permissions());
        }
        if ("owner".equals(prefix) && owner != null) {
            map.put("owner", this.owner().getName());
        }
        return map;
    }

    @Override
    public String name() {
        if (this.file == null) {
            return null;
        }
        String name = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            name = this.file.getName();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return name;
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this;
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
        if (this.file == null) {
            return;
        }
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.file.setProperty((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)perms.contains((Object)PosixFilePermission.GROUP_READ));
            this.file.setProperty((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)perms.contains((Object)PosixFilePermission.OTHERS_READ));
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Unable to set mapped file permissions for " + this.file, (Throwable)fex);
        }
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
    }
}

