/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.files.ssh.filesystem.StructrFileAttributes;
import org.structr.files.ssh.filesystem.StructrFilesystemProvider;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.StructrRootPath;
import org.structr.files.ssh.filesystem.path.file.StructrFilePath;

public class StructrFilesystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFilesystem.class.getName());
    private StructrFilesystemProvider provider = new StructrFilesystemProvider();
    private SecurityContext securityContext = null;
    private String lastFullPath = null;
    private StructrPath last = null;
    private StructrPath root = new StructrRootPath(this);

    public StructrFilesystem(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Arrays.asList(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return StructrFileAttributes.SUPPORTED_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        StringBuilder pathBuilder = new StringBuilder(first);
        for (String component : more) {
            pathBuilder.append("/");
            pathBuilder.append(component);
        }
        String fullPath = pathBuilder.toString();
        StructrPath path = this.last;
        if (fullPath.equals(this.lastFullPath) && this.last != null && !this.last.dontCache()) {
            return this.last;
        }
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String[] parts = fullPath.split("/");
            if (fullPath.startsWith("/")) {
                path = this.root;
            }
            for (int i = 0; i < parts.length; ++i) {
                String component = parts[i];
                if (component.isEmpty()) continue;
                path = path != null ? path.resolveStructrPath(component) : new StructrFilePath(this, null, component);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.lastFullPath = fullPath;
        this.last = path;
        return path;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    Path getRoot() {
        return this.root;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }
}

