/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.path.file.StructrFilePath;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;

public abstract class StructrPath
implements Path {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPath.class.getName());
    public static final Map<String, HiddenFileEntry> HIDDEN_PROPERTY_FILES = new ConcurrentHashMap<String, HiddenFileEntry>();
    public static final String ROOT_DIRECTORY = "/";
    public static final String CURRENT_DIRECTORY = ".";
    public static final String SCHEMA_DIRECTORY = "schema";
    public static final String PAGE_DIRECTORY = "pages";
    public static final String GRAPH_DIRECTORY = "graph";
    public static final String FILES_DIRECTORY = "files";
    public static final String COMPONENTS_DIRECTORY = "components";
    protected StructrFilesystem fs = null;
    protected StructrPath parent = null;
    protected String name = null;

    public StructrPath(StructrFilesystem fs) {
        this(fs, null, null);
    }

    public StructrPath(StructrFilesystem fs, StructrPath parent, String name) {
        this.parent = parent;
        this.name = name;
        this.fs = fs;
    }

    public abstract DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> var1);

    public abstract FileChannel newFileChannel(Set<? extends OpenOption> var1, FileAttribute<?> ... var2) throws IOException;

    public abstract <T extends BasicFileAttributes> T getAttributes(Class<T> var1, LinkOption ... var2) throws IOException;

    public abstract <V extends FileAttributeView> V getFileAttributeView(Class<V> var1, LinkOption ... var2) throws IOException;

    public abstract Map<String, Object> getAttributes(String var1, LinkOption ... var2) throws IOException;

    public abstract void createDirectory(FileAttribute<?> ... var1) throws IOException;

    public abstract void delete() throws IOException;

    public abstract void copy(Path var1, CopyOption ... var2) throws IOException;

    public abstract void move(Path var1, CopyOption ... var2) throws IOException;

    public abstract void setAttribute(String var1, Object var2, LinkOption ... var3) throws IOException;

    public abstract boolean isSameFile(Path var1) throws IOException;

    public abstract StructrPath resolveStructrPath(String var1) throws FrameworkException;

    public void checkAccess(AccessMode ... modes) {
    }

    public void enablePropertyFile(String name) {
    }

    public boolean hasPropertyFile(String name) {
        return true;
    }

    public boolean dontCache() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.parent != null) {
            String parentPath = this.parent.toString();
            if (!ROOT_DIRECTORY.equals(parentPath)) {
                buf.append(parentPath);
            }
            buf.append(ROOT_DIRECTORY);
        }
        if (this.name != null) {
            buf.append(this.name);
        }
        return buf.toString();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        if (this.parent != null) {
            return this.parent.isAbsolute();
        }
        return this.name == null;
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return this.parent.getRoot();
        }
        return null;
    }

    @Override
    public Path getParent() {
        return this.parent;
    }

    @Override
    public Path getFileName() {
        if (this.name != null) {
            return new StructrFilePath(this.fs, null, this.name);
        }
        return null;
    }

    @Override
    public int getNameCount() {
        if (this.parent != null) {
            return this.parent.getNameCount() + 1;
        }
        if (this.name != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public Path getName(int index) {
        ArrayList<StructrPath> paths = new ArrayList<StructrPath>();
        Path path = this;
        paths.add(this);
        while (path.getParent() != null) {
            path = path.getParent();
            paths.add(0, (StructrPath)path);
        }
        return (Path)paths.get(index);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        logger.info("{}, {}", new Object[]{beginIndex, endIndex});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean startsWith(Path other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean startsWith(String other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean endsWith(Path other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean endsWith(String other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        logger.info("{}", new Object[]{other});
        return null;
    }

    @Override
    public Path resolve(String other) {
        if (other.startsWith(ROOT_DIRECTORY)) {
            return this.fs.getPath(other, new String[0]);
        }
        if (CURRENT_DIRECTORY.equals(other)) {
            return this;
        }
        logger.info("{}", new Object[]{other});
        return this.fs.getPath(this.toString(), other);
    }

    @Override
    public Path resolveSibling(Path other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path resolveSibling(String other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path relativize(Path other) {
        logger.info("{}, {}", new Object[]{other});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URI toUri() {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fs.getPath(this.toString(), this.name);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public File toFile() {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<Path> iterator() {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int compareTo(Path other) {
        logger.info("x");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String normalizeFileNameForJavaIdentifier(String src) {
        String dst = src;
        dst = dst.replace('/', '_');
        dst = dst.replace('.', '_');
        dst = dst.replace('-', '_');
        dst = dst.replace('+', '_');
        dst = dst.replace('~', '_');
        dst = dst.replace('#', '_');
        dst = dst.replace('\'', '_');
        dst = dst.replace('\"', '_');
        dst = dst.replace('`', '_');
        dst = dst.replace('(', '_');
        dst = dst.replace(')', '_');
        dst = dst.replace('[', '_');
        dst = dst.replace(']', '_');
        dst = dst.replace('{', '_');
        dst = dst.replace('}', '_');
        dst = dst.replace('!', '_');
        dst = dst.replace('$', '_');
        dst = dst.replace('\u00a7', '_');
        dst = dst.replace('%', '_');
        dst = dst.replace('&', '_');
        dst = dst.replace('=', '_');
        dst = dst.replace(':', '_');
        dst = dst.replace('<', '_');
        dst = dst.replace('>', '_');
        dst = dst.replace('|', '_');
        dst = dst.replace('^', '_');
        dst = dst.replace('\u00b0', '_');
        return dst;
    }

    protected String getName(String tagName, DOMNode node, int position) {
        StringBuilder buf = new StringBuilder();
        int localPosition = this.getDomPosition(node, position);
        if (localPosition < 10) {
            buf.append("0");
        }
        if (localPosition < 100) {
            buf.append("0");
        }
        if (localPosition < 1000) {
            buf.append("0");
        }
        buf.append(localPosition);
        buf.append("-");
        if (node != null) {
            if (node instanceof DOMElement) {
                DOMElement elem = (DOMElement)node;
                buf.append(elem.getTagName());
            } else {
                buf.append(node.getType().toLowerCase());
            }
        } else if (tagName != null) {
            buf.append(tagName);
        }
        return buf.toString();
    }

    protected int getDomPosition(DOMNode node, int index) {
        Integer storedPosition;
        Integer localPosition = (index + 1) * 100;
        if (node != null && (storedPosition = (Integer)node.getProperty((PropertyKey)DOMNode.domSortPosition)) != null) {
            localPosition = storedPosition;
        }
        return localPosition;
    }

    public static class HiddenFileEntry {
        private final Set<String> dynamicNames = new LinkedHashSet<String>();
        private final Set<String> names = new LinkedHashSet<String>();

        public void add(String name) {
            this.names.add(name);
        }

        public boolean has(String name) {
            return this.names.contains(name);
        }

        public void remove(String name) {
            this.names.remove(name);
        }

        public boolean isEmpty() {
            return this.names.isEmpty();
        }

        public void addDynamicWithValue(String name) {
            this.dynamicNames.add(name);
        }

        public boolean hasDynamicWithValue(String name) {
            return this.dynamicNames.contains(name);
        }

        public void removeDynamicWithValue(String name) {
            this.dynamicNames.remove(name);
        }
    }
}

