/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem;

import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StructrRootAttributes
implements PosixFileAttributes,
DosFileAttributes {
    public static final Set<String> SUPPORTED_VIEWS = new LinkedHashSet<String>(Arrays.asList("owner", "dos", "basic", "posix"));
    private String key = null;

    public StructrRootAttributes(String key) {
        this.key = key;
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public FileTime creationTime() {
        return FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isRegularFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public Object fileKey() {
        return this.key;
    }

    @Override
    public UserPrincipal owner() {
        return new UserPrincipal(){

            @Override
            public String getName() {
                return "superadmin";
            }
        };
    }

    @Override
    public GroupPrincipal group() {
        return new GroupPrincipal(){

            @Override
            public String getName() {
                return "superadmin";
            }
        };
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        return permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = filter.substring(0, filter.indexOf(":"));
        if ("dos".equals(prefix)) {
            map.put("hidden", this.isHidden());
            map.put("archive", this.isArchive());
            map.put("system", this.isSystem());
            map.put("readonly", this.isReadOnly());
        }
        if (!"owner".equals(prefix)) {
            map.put("lastModifiedTime", this.lastModifiedTime());
            map.put("lastAccessTime", this.lastAccessTime());
            map.put("creationTime", this.creationTime());
            map.put("size", this.size());
            map.put("isRegularFile", this.isRegularFile());
            map.put("isDirectory", this.isDirectory());
            map.put("isSymbolicLink", this.isSymbolicLink());
            map.put("isOther", this.isOther());
            map.put("fileKey", this.fileKey());
        }
        if ("posix".equals(prefix)) {
            map.put("permissions", this.permissions());
            map.put("group", this.group().getName());
            map.put("owner", this.owner().getName());
        }
        if ("owner".equals(prefix)) {
            map.put("owner", this.owner().getName());
        }
        return map;
    }
}

