/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.components;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrToplevelAttributes;
import org.structr.files.ssh.filesystem.path.components.StructrNonexistingComponentPath;
import org.structr.files.ssh.filesystem.path.page.StructrDOMNodePath;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.relationship.DOMChildren;

public class StructrComponentsPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrComponentsPath.class.getName());

    public StructrComponentsPath(StructrFilesystem fs, StructrPath parent) {
        super(fs, parent, "components");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return new DirectoryStream(){
            boolean closed = false;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Iterator iterator() {
                if (this.closed) return Collections.emptyIterator();
                App app = StructrApp.getInstance((SecurityContext)StructrComponentsPath.this.fs.getSecurityContext());
                LinkedList<StructrDOMNodePath> components = new LinkedList<StructrDOMNodePath>();
                int pos = 0;
                try (Tx tx = app.tx();){
                    ShadowDocument doc = (ShadowDocument)app.nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getFirst();
                    if (doc != null) {
                        for (DOMNode node : (List)doc.getProperty((PropertyKey)Page.elements)) {
                            if (node.hasIncomingRelationships(DOMChildren.class)) continue;
                            components.add(new StructrDOMNodePath(StructrComponentsPath.this.fs, StructrComponentsPath.this, (Page)doc, null, node, StructrComponentsPath.this.createComponentName(node, pos++)));
                        }
                    }
                    tx.success();
                    Iterator iterator = components.iterator();
                    return iterator;
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to create directory stream", (Throwable)fex);
                }
                return Collections.emptyIterator();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) throws FrameworkException {
        int pos = 0;
        ShadowDocument doc = (ShadowDocument)StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getFirst();
        if (doc != null) {
            for (DOMNode child : (List)doc.getProperty((PropertyKey)Page.elements)) {
                if (child.hasIncomingRelationships(DOMChildren.class) || !pathComponent.equals(this.createComponentName(child, pos++))) continue;
                return new StructrDOMNodePath(this.fs, this, (Page)doc, null, child, pathComponent);
            }
        }
        return new StructrNonexistingComponentPath(this.fs, this, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) {
        return new StructrToplevelAttributes("components").toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) {
        return (T)new StructrToplevelAttributes("components");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String createComponentName(DOMNode node, int pos) {
        StringBuilder buf = new StringBuilder();
        String name = "unnamed" + pos;
        if (node != null) {
            buf.append(node.getType().toLowerCase());
            name = (String)node.getProperty((PropertyKey)AbstractNode.name);
        } else {
            buf.append("none");
        }
        buf.append("-");
        buf.append(name);
        return buf.toString();
    }
}

