/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.graph;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.path.graph.StructrPropertyValueChannel;

public class StructrPropertyValueAttributes
implements PosixFileAttributes,
DosFileAttributes,
PosixFileAttributeView {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPropertyValueAttributes.class.getName());
    public static final Set<String> SUPPORTED_VIEWS = new LinkedHashSet<String>(Arrays.asList("unix"));
    private SecurityContext securityContext = null;
    private PropertyKey key = null;
    private GraphObject node = null;

    public StructrPropertyValueAttributes(SecurityContext securityContext, GraphObject node, PropertyKey key) {
        this.securityContext = securityContext;
        this.node = node;
        this.key = key;
    }

    @Override
    public UserPrincipal owner() {
        return null;
    }

    @Override
    public GroupPrincipal group() {
        return null;
    }

    @Override
    public FileTime lastModifiedTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.lastModifiedDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime lastAccessTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.lastModifiedDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime creationTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.createdDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public boolean isRegularFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        if (this.node == null) {
            return 0L;
        }
        long size = 0L;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String value = StructrPropertyValueChannel.getConvertedPropertyValue(this.securityContext, this.node, this.key);
            if (value != null) {
                size = value.toString().getBytes(Charset.forName("utf-8")).length;
            }
            tx.success();
        }
        catch (IOException | FrameworkException ioex) {
            logger.warn("", ioex);
        }
        return size;
    }

    @Override
    public Object fileKey() {
        if (this.node == null) {
            return null;
        }
        String uuid = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            uuid = this.node.getUuid();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return uuid;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        if (!(this.key.isSystemInternal() || this.key.isReadOnly() || this.key.isWriteOnce())) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        return permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = filter.substring(0, filter.indexOf(":"));
        if ("dos".equals(prefix)) {
            map.put("hidden", this.isHidden());
            map.put("archive", this.isArchive());
            map.put("system", this.isSystem());
            map.put("readonly", this.isReadOnly());
        }
        if (!"owner".equals(prefix)) {
            map.put("lastModifiedTime", this.lastModifiedTime());
            map.put("lastAccessTime", this.lastAccessTime());
            map.put("creationTime", this.creationTime());
            map.put("size", this.size());
            map.put("isRegularFile", this.isRegularFile());
            map.put("isDirectory", this.isDirectory());
            map.put("isSymbolicLink", this.isSymbolicLink());
            map.put("isOther", this.isOther());
            map.put("fileKey", this.fileKey());
        }
        if ("posix".equals(prefix)) {
            map.put("permissions", this.permissions());
            map.put("group", this.group());
            map.put("owner", this.owner());
        }
        if ("permissions".equals(prefix)) {
            map.put("permissions", this.permissions());
        }
        if ("owner".equals(prefix)) {
            map.put("owner", this.owner());
        }
        map.put("gid", 0);
        map.put("uid", 0);
        return map;
    }

    @Override
    public String name() {
        return this.key.jsonName();
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this;
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
    }
}

