/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.graph;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrPath;

public class StructrPropertyValueChannel<T extends GraphObject>
extends FileChannel {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPropertyValueChannel.class.getName());
    private ByteBuffer buffer = ByteBuffer.allocate(65535);
    private SecurityContext securityContext = null;
    private GraphObject graphObject = null;
    private PropertyKey key = null;
    private boolean dataWasWritten = false;
    private boolean truncate = false;
    private boolean append = false;

    public StructrPropertyValueChannel(SecurityContext securityContext, GraphObject src, PropertyKey key, boolean truncate, boolean append) {
        this.securityContext = securityContext;
        this.truncate = truncate;
        this.append = append;
        this.graphObject = src;
        this.key = key;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            String stringValue = StructrPropertyValueChannel.getConvertedPropertyValue(this.securityContext, this.graphObject, this.key);
            byte[] bytes = stringValue.getBytes(Charset.forName("utf-8"));
            dst.put(bytes);
            return bytes.length;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return 0;
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return 0L;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        int len = src.remaining();
        this.buffer.put(src);
        this.dataWasWritten = true;
        return len;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        this.dataWasWritten = true;
        return 0L;
    }

    @Override
    public long position() throws IOException {
        return 0L;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return this;
    }

    @Override
    public long size() throws IOException {
        try {
            return StructrPropertyValueChannel.getConvertedPropertyValue(this.securityContext, this.graphObject, this.key).getBytes(Charset.forName("utf-8")).length;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return 0L;
        }
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return 0L;
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return 0L;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return 0;
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return 0;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return null;
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return null;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        StructrPropertyValueChannel.checkWriteAccess(this.key);
        return null;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.dataWasWritten && this.graphObject != null) {
            try {
                this.buffer.flip();
                byte[] data = new byte[this.buffer.remaining()];
                this.buffer.get(data);
                String value = new String(data, Charset.forName("utf-8"));
                StringBuilder buf = new StringBuilder();
                if (this.append) {
                    buf.append(StructrPropertyValueChannel.getConvertedPropertyValue(this.securityContext, this.graphObject, this.key));
                }
                buf.append(value);
                StructrPropertyValueChannel.setConvertedPropertyValue(this.securityContext, this.graphObject, this.key, value);
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    public static String getConvertedPropertyValue(SecurityContext securityContext, GraphObject graphObject, PropertyKey key) throws IOException, FrameworkException {
        PropertyConverter inputConverter = key.inputConverter(securityContext);
        Object actualValue = graphObject.getProperty(key);
        if (inputConverter != null) {
            actualValue = inputConverter.revert(actualValue);
        }
        if (actualValue != null) {
            return actualValue.toString();
        }
        return "";
    }

    public static void setConvertedPropertyValue(SecurityContext securityContext, GraphObject graphObject, PropertyKey key, String value) throws IOException, FrameworkException {
        StructrPath.HiddenFileEntry entry;
        PropertyConverter converter = key.inputConverter(securityContext);
        String previousUuid = graphObject.getUuid();
        Object actualValue = value;
        if (converter != null) {
            actualValue = converter.convert(actualValue);
        }
        if (key.isReadOnly()) {
            graphObject.unlockReadOnlyPropertiesOnce();
        }
        if (key.isSystemInternal()) {
            graphObject.unlockSystemPropertiesOnce();
        }
        graphObject.setProperty(key, actualValue);
        if (GraphObject.id.equals((Object)key) && (entry = StructrPath.HIDDEN_PROPERTY_FILES.get(previousUuid)) != null) {
            StructrPath.HIDDEN_PROPERTY_FILES.remove(previousUuid);
            StructrPath.HIDDEN_PROPERTY_FILES.put(value, entry);
        }
    }

    private static void handleFrameworkException(FrameworkException fex, String name) throws IOException {
        switch (fex.getStatus()) {
            case 401: 
            case 403: {
                throw new AccessDeniedException(name);
            }
            case 404: {
                throw new NoSuchFileException(name);
            }
        }
        throw new IllegalArgumentException(fex.getMessage());
    }

    public static void checkWriteAccess(PropertyKey key) throws IOException {
    }
}

