/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.shell;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.files.ssh.StructrShellCommand;
import org.structr.files.ssh.shell.NonInteractiveShellCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;

public class CatCommand
extends NonInteractiveShellCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CatCommand.class.getName());

    @Override
    public void execute(StructrShellCommand parent) throws IOException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            Folder currentFolder = parent.getCurrentFolder();
            if (currentFolder != null) {
                this.listFolder(parent, (List)currentFolder.getProperty((PropertyKey)AbstractFile.children));
            } else {
                this.listFolder(parent, app.nodeQuery(AbstractFile.class).and((PropertyKey)AbstractFile.parent, null).getAsList());
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void handleTabCompletion(StructrShellCommand parent, String line, int tabCount) throws IOException {
        if (line.contains(" ") && line.length() >= 3) {
            String incompletePath = line.substring(line.indexOf(" ") + 1);
            Folder baseFolder = null;
            String lastPathPart = null;
            if (incompletePath.startsWith("\"")) {
                incompletePath = incompletePath.substring(1);
            }
            App app = StructrApp.getInstance();
            if ("..".equals(incompletePath)) {
                this.term.handleCharacter(47);
                return;
            }
            if (incompletePath.startsWith("/")) {
                incompletePath = incompletePath.substring(1);
            } else {
                baseFolder = parent.getCurrentFolder();
            }
            String[] parts = incompletePath.split("[/]+");
            int partCount = parts.length;
            try (Tx tx = app.tx();){
                if (partCount == 1) {
                    lastPathPart = parts[0];
                } else {
                    lastPathPart = parts[partCount - 1];
                    for (int i = 0; i < partCount - 1; ++i) {
                        if (!StringUtils.isNotBlank((CharSequence)parts[i]) || (baseFolder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)AbstractFile.parent, (Object)baseFolder).and((PropertyKey)Folder.name, (Object)parts[i]).getFirst()) != null) continue;
                        return;
                    }
                }
                LinkedList allFiles = new LinkedList();
                LinkedList<AbstractFile> files = new LinkedList<AbstractFile>();
                if (baseFolder != null) {
                    allFiles.addAll((Collection)baseFolder.getProperty((PropertyKey)AbstractFile.children));
                } else {
                    allFiles.addAll(app.nodeQuery(AbstractFile.class).and((PropertyKey)File.parent, null).getAsList());
                }
                for (AbstractFile file : allFiles) {
                    if (!file.getName().startsWith(lastPathPart)) continue;
                    files.add(file);
                }
                if (files.size() > 1) {
                    if (tabCount > 1) {
                        this.displayAutocompleteSuggestions(parent, files, line);
                    }
                } else if (!files.isEmpty()) {
                    AbstractFile file = (AbstractFile)files.get(0);
                    if (file instanceof Folder) {
                        Folder folder = (Folder)file;
                        if (parent.isAllowed((AbstractFile)folder, Permission.read, false)) {
                            if (lastPathPart.equals(folder.getName())) {
                                if (tabCount > 1) {
                                    this.displayAutocompleteSuggestions(parent, (List)folder.getProperty((PropertyKey)Folder.children), line);
                                } else if (!line.endsWith("/")) {
                                    this.term.handleCharacter(47);
                                }
                            } else {
                                this.displayAutocompleteItem((AbstractFile)folder, lastPathPart);
                            }
                        }
                    } else {
                        AbstractFile existingFile = (AbstractFile)files.get(0);
                        if (parent.isAllowed(existingFile, Permission.read, false) && !lastPathPart.equals(existingFile.getName())) {
                            this.displayAutocompleteItem(existingFile, lastPathPart);
                        }
                    }
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    private void listFolder(StructrShellCommand parent, List<AbstractFile> folder) throws FrameworkException, IOException {
        for (AbstractFile child : folder) {
            if (!parent.isAllowed(child, Permission.read, false)) continue;
            if (child instanceof Folder) {
                this.term.setBold(true);
                this.term.setTextColor(4);
                this.term.print(new Object[]{child.getName() + "  "});
                this.term.setTextColor(7);
                this.term.setBold(false);
                continue;
            }
            this.term.print(new Object[]{child.getName() + "  "});
        }
        if (!folder.isEmpty()) {
            this.term.println();
        }
    }

    private void displayAutocompleteItem(AbstractFile file, String part) throws IOException {
        String remainder;
        String name = file.getName();
        if (name.startsWith(part) && StringUtils.isNotEmpty((CharSequence)(remainder = file.getName().substring(part.length())))) {
            this.term.handleString(remainder);
            if (file instanceof Folder) {
                this.term.handleCharacter(47);
            }
        }
    }

    private void displayAutocompleteSuggestions(StructrShellCommand parent, List<AbstractFile> files, String line) throws IOException {
        if (!files.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (AbstractFile file : files) {
                if (!parent.isAllowed(file, Permission.read, false)) continue;
                buf.append(file.getName());
                if (!(file instanceof Folder)) continue;
                buf.append("/  ");
            }
            if (buf.length() > 0) {
                this.term.println();
                this.term.print(new Object[]{buf.toString()});
                this.term.println();
                parent.displayPrompt();
                this.term.print(new Object[]{line});
            }
        }
    }
}

