/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.shell;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrShellCommand;
import org.structr.files.ssh.shell.NonInteractiveShellCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;

public class CdCommand
extends NonInteractiveShellCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CdCommand.class.getName());
    private String target = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(StructrShellCommand parent) throws IOException {
        App app = StructrApp.getInstance();
        Folder currentFolder = parent.getCurrentFolder();
        try (Tx tx = app.tx();){
            if (this.target != null) {
                switch (this.target) {
                    case "..": {
                        if (currentFolder == null) break;
                        Folder parentFolder = (Folder)currentFolder.getProperty((PropertyKey)AbstractFile.parent);
                        if (parentFolder != null) {
                            if (!parent.isAllowed((AbstractFile)parentFolder, Permission.read, true)) break;
                            parent.setCurrentFolder(parentFolder);
                            break;
                        }
                        parent.setCurrentFolder(null);
                        break;
                    }
                    case ".": {
                        break;
                    }
                    case "/": {
                        parent.setCurrentFolder(null);
                        break;
                    }
                    case "~": {
                        parent.setCurrentFolder((Folder)this.user.getProperty((PropertyKey)User.homeDirectory));
                        break;
                    }
                    default: {
                        this.setFolder(parent, currentFolder, this.target);
                        break;
                    }
                }
            } else {
                parent.setCurrentFolder((Folder)this.user.getProperty((PropertyKey)User.homeDirectory));
            }
            tx.success();
            return;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void setCommand(String command) throws IOException {
        if (command.contains(" ") && command.length() > 3) {
            this.target = command.substring(command.indexOf(" ") + 1);
            if (this.target.startsWith("\"")) {
                if (this.target.endsWith("\"")) {
                    this.target = this.target.substring(1, this.target.length() - 2);
                } else {
                    this.term.print(new Object[]{"Unmatched quotes"});
                }
            }
            if (this.target != null && this.target.endsWith("/") && this.target.length() > 1) {
                this.target = this.target.substring(0, this.target.length() - 1);
            }
        }
    }

    @Override
    public void handleTabCompletion(StructrShellCommand parent, String line, int tabCount) throws IOException {
        if (line.contains(" ") && line.length() >= 3) {
            String incompletePath = line.substring(line.indexOf(" ") + 1);
            Folder baseFolder = null;
            String lastPathPart = null;
            if (incompletePath.startsWith("\"")) {
                incompletePath = incompletePath.substring(1);
            }
            App app = StructrApp.getInstance();
            if ("..".equals(incompletePath)) {
                this.term.handleCharacter(47);
                return;
            }
            if (incompletePath.startsWith("/")) {
                incompletePath = incompletePath.substring(1);
            } else {
                baseFolder = parent.getCurrentFolder();
            }
            String[] parts = incompletePath.split("[/]+");
            int partCount = parts.length;
            try (Tx tx = app.tx();){
                Folder folder;
                if (partCount == 1) {
                    lastPathPart = parts[0];
                } else {
                    lastPathPart = parts[partCount - 1];
                    for (int i = 0; i < partCount - 1; ++i) {
                        if (!StringUtils.isNotBlank((CharSequence)parts[i]) || (baseFolder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)AbstractFile.parent, (Object)baseFolder).and((PropertyKey)Folder.name, (Object)parts[i]).getFirst()) != null) continue;
                        return;
                    }
                }
                List allFolders = app.nodeQuery(Folder.class).and((PropertyKey)AbstractFile.parent, (Object)baseFolder).getAsList();
                LinkedList<Folder> folders = new LinkedList<Folder>();
                for (Folder folder2 : allFolders) {
                    if (!folder2.getName().startsWith(lastPathPart)) continue;
                    folders.add(folder2);
                }
                if (folders.size() > 1) {
                    if (tabCount > 1) {
                        this.displayAutocompleteSuggestions(parent, folders, line);
                    }
                } else if (!folders.isEmpty() && parent.isAllowed((AbstractFile)(folder = (Folder)folders.get(0)), Permission.read, false)) {
                    if (lastPathPart.equals(folder.getName())) {
                        if (tabCount > 1) {
                            this.displayAutocompleteSuggestions(parent, (List)folder.getProperty((PropertyKey)Folder.folders), line);
                        } else if (!line.endsWith("/")) {
                            this.term.handleCharacter(47);
                        }
                    } else {
                        this.displayAutocompleteFolder(folder, lastPathPart);
                    }
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    private void setFolder(StructrShellCommand parent, Folder currentFolder, String targetFolderName) throws IOException, FrameworkException {
        App app = StructrApp.getInstance();
        String target = targetFolderName;
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        if (target.startsWith("/")) {
            Folder folder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)Folder.path, (Object)target).getFirst();
            if (folder != null) {
                if (parent.isAllowed((AbstractFile)folder, Permission.read, true)) {
                    parent.setCurrentFolder(folder);
                } else {
                    this.term.println(new Object[]{"Permission denied"});
                }
            } else {
                this.term.println(new Object[]{"Folder " + target + " does not exist"});
            }
        } else {
            Folder newFolder = parent.findRelativeFolder(currentFolder, target);
            if (newFolder == null) {
                this.term.println(new Object[]{"Folder " + target + " does not exist"});
            } else if (parent.isAllowed((AbstractFile)newFolder, Permission.read, true)) {
                parent.setCurrentFolder(newFolder);
            } else {
                this.term.println(new Object[]{"Permission denied"});
            }
        }
    }

    private void displayAutocompleteFolder(Folder folder, String part) throws IOException {
        String remainder;
        String name = folder.getName();
        if (name.startsWith(part) && StringUtils.isNotEmpty((CharSequence)(remainder = folder.getName().substring(part.length())))) {
            this.term.handleString(remainder);
            this.term.handleCharacter(47);
        }
    }

    private void displayAutocompleteSuggestions(StructrShellCommand parent, List<Folder> folders, String line) throws IOException {
        if (!folders.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (Folder folder : folders) {
                if (!parent.isAllowed((AbstractFile)folder, Permission.read, false)) continue;
                buf.append(folder.getName()).append("/  ");
            }
            if (buf.length() > 0) {
                this.term.println();
                this.term.print(new Object[]{buf.toString()});
                this.term.println();
                parent.displayPrompt();
                this.term.print(new Object[]{line});
            }
        }
    }
}

