/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.shell;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrShellCommand;
import org.structr.files.ssh.shell.InteractiveShellCommand;
import org.structr.web.entity.User;

public class PasswordCommand
extends InteractiveShellCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)PasswordCommand.class.getName());
    private String firstPassword = null;
    private String secondPassword = null;

    @Override
    public void execute(StructrShellCommand parent) throws IOException {
        this.term.setEcho(false);
        super.execute(parent);
        try (Tx tx = StructrApp.getInstance().tx();){
            this.term.println(new Object[]{"Changing password for " + this.user.getName()});
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void displayPrompt() throws IOException {
        if (this.firstPassword == null) {
            try (Tx tx = StructrApp.getInstance().tx();){
                this.term.print(new Object[]{"Enter new password: "});
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        } else if (this.secondPassword == null) {
            this.term.print(new Object[]{"Confim password: "});
        }
    }

    @Override
    public void handleLine(String line) throws IOException {
        if (this.firstPassword == null) {
            if (StringUtils.isEmpty((String)line)) {
                this.term.println(new Object[]{"Empty password not permitted."});
            } else {
                this.firstPassword = line;
            }
        } else if (this.secondPassword == null) {
            this.secondPassword = line;
            if (this.firstPassword.equals(this.secondPassword)) {
                try (Tx tx = StructrApp.getInstance().tx();){
                    this.user.setProperty((PropertyKey)User.password, (Object)this.firstPassword);
                    tx.success();
                    this.term.println(new Object[]{"Password changed."});
                }
                catch (FrameworkException fex) {
                    this.term.println(new Object[]{"Password NOT changed: " + fex.getMessage()});
                }
            } else {
                this.term.println(new Object[]{"Password NOT changed, passwords don't match."});
            }
            this.term.restoreRootTerminalHandler();
        }
    }
}

