/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.nltk;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.parser.ner.NERecogniser;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLTKNERecogniser
implements NERecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(NLTKNERecogniser.class);
    private static boolean available = false;
    private static final String NLTK_REST_HOST = "http://localhost:8881";
    private String restHostUrlStr;
    public static final Set<String> ENTITY_TYPES = new HashSet<String>(){
        {
            this.add("NAMES");
        }
    };

    public NLTKNERecogniser() {
        try {
            String restHostUrlStr = "";
            try {
                restHostUrlStr = NLTKNERecogniser.readRestUrl();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.restHostUrlStr = restHostUrlStr == null || restHostUrlStr.equals("") ? NLTK_REST_HOST : restHostUrlStr;
            Response response = WebClient.create((String)restHostUrlStr).accept(new String[]{"text/html"}).get();
            int responseCode = response.getStatus();
            if (responseCode == 200) {
                available = true;
            } else {
                LOG.info("NLTKRest Server is not running");
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }

    private static String readRestUrl() throws IOException {
        Properties nltkProperties = new Properties();
        nltkProperties.load(NLTKNERecogniser.class.getResourceAsStream("NLTKServer.properties"));
        return nltkProperties.getProperty("nltk.server.url");
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return ENTITY_TYPES;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        HashMap<String, Set<String>> entities = new HashMap<String, Set<String>>();
        try {
            String url = this.restHostUrlStr + "/nltk";
            Response response = WebClient.create((String)url).accept(new String[]{"text/html"}).post((Object)text);
            int responseCode = response.getStatus();
            if (responseCode == 200) {
                String result = (String)response.readEntity(String.class);
                JSONParser parser = new JSONParser();
                JSONObject j = (JSONObject)parser.parse(result);
                for (String key : j.keySet()) {
                    if (key.equals("result")) continue;
                    ENTITY_TYPES.add(key);
                    entities.put(key.toUpperCase(Locale.ENGLISH), new HashSet((Collection)j.get((Object)key)));
                }
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return entities;
    }
}

