/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;

public class PrimitiveLongStack
implements PrimitiveLongCollection {
    private long[] array;
    private int cursor = -1;

    public PrimitiveLongStack() {
        this(16);
    }

    public PrimitiveLongStack(int initialSize) {
        this.array = new long[initialSize];
    }

    @Override
    public boolean isEmpty() {
        return this.cursor == -1;
    }

    @Override
    public void clear() {
        this.cursor = -1;
    }

    @Override
    public int size() {
        return this.cursor + 1;
    }

    @Override
    public void close() {
    }

    @Override
    public PrimitiveLongIterator iterator() {
        return new PrimitiveLongIterator(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx <= PrimitiveLongStack.this.cursor;
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PrimitiveLongStack.this.array[this.idx++];
            }
        };
    }

    public void visitKeys(PrimitiveLongVisitor visitor) {
        throw new UnsupportedOperationException("Please implement");
    }

    public void push(long value) {
        this.ensureCapacity();
        this.array[++this.cursor] = value;
    }

    private void ensureCapacity() {
        if (this.cursor == this.array.length - 1) {
            this.array = Arrays.copyOf(this.array, this.array.length << 1);
        }
    }

    public long poll() {
        return this.cursor == -1 ? -1L : this.array[this.cursor--];
    }
}

