/*
 * Decompiled with CFR 0.152.
 */
package org.structr.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.Agent;
import org.structr.agent.ReturnValue;
import org.structr.agent.Task;
import org.structr.api.graph.Node;
import org.structr.api.index.Index;
import org.structr.common.fulltext.Indexable;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Person;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.text.FulltextIndexingTask;
import org.structr.text.FulltextTokenizer;
import org.xml.sax.ContentHandler;

public class FulltextIndexingAgent
extends Agent<Indexable> {
    private static final Logger logger = LoggerFactory.getLogger((String)FulltextIndexingAgent.class.getName());
    private static final Map<String, Set<String>> languageStopwordMap = new LinkedHashMap<String, Set<String>>();
    public static final String TASK_NAME = "FulltextIndexing";

    public ReturnValue processTask(Task<Indexable> task) throws Throwable {
        if (TASK_NAME.equals(task.getType())) {
            for (Indexable file : task.getNodes()) {
                this.doIndexing(file);
            }
            return ReturnValue.Success;
        }
        return ReturnValue.Abort;
    }

    public Class getSupportedTaskType() {
        return FulltextIndexingTask.class;
    }

    public boolean createEnclosingTransaction() {
        return false;
    }

    private void doIndexing(Indexable file) {
        block79: {
            boolean parsingSuccessful = false;
            InputStream inputStream = null;
            String fileName = "unknown file";
            try {
                try (Tx tx = StructrApp.getInstance().tx();){
                    inputStream = file.getInputStream();
                    fileName = file.getName();
                    tx.success();
                }
                if (inputStream == null) break block79;
                var6_7 = null;
                try (FulltextTokenizer tokenizer = new FulltextTokenizer(fileName);){
                    Throwable throwable;
                    Tx tx;
                    try (InputStream is = inputStream;){
                        DefaultDetector detector = new DefaultDetector(MimeTypes.getDefaultMimeTypes());
                        AutoDetectParser parser = new AutoDetectParser((Detector)detector);
                        HashMap<MediaType, PDFParser> customParsers = new HashMap<MediaType, PDFParser>();
                        customParsers.put(MediaType.application((String)"pdf"), new PDFParser());
                        parser.setParsers(customParsers);
                        Metadata metadata = new Metadata();
                        parser.parse(is, (ContentHandler)new BodyContentHandler((Writer)tokenizer), metadata);
                        parsingSuccessful = true;
                        logger.info(String.join((CharSequence)", ", metadata.names()));
                    }
                    if (!parsingSuccessful) break block79;
                    var8_14 = null;
                    try (Tx tx2 = StructrApp.getInstance().tx();){
                        file.getSecurityContext().preventModificationOfAccessTime();
                        file.setProperty((PropertyKey)Indexable.extractedContent, (Object)tokenizer.getRawText());
                        tokenizer.write(this.getName());
                        Principal _owner = (Principal)file.getProperty((PropertyKey)NodeInterface.owner);
                        if (_owner != null) {
                            String twitterName;
                            String eMail;
                            String ownerName = _owner.getName();
                            if (ownerName != null) {
                                tokenizer.write(ownerName);
                            }
                            if ((eMail = (String)_owner.getProperty((PropertyKey)Person.eMail)) != null) {
                                tokenizer.write(eMail);
                            }
                            if ((twitterName = (String)_owner.getProperty((PropertyKey)Person.twitterName)) != null) {
                                tokenizer.write(twitterName);
                            }
                        }
                        tx2.success();
                    }
                    catch (Throwable _owner) {
                        var8_14 = _owner;
                        throw _owner;
                    }
                    NodeService nodeService = (NodeService)Services.getInstance().getService(NodeService.class);
                    Index fulltextIndex = nodeService.getNodeIndex();
                    Set<String> stopWords = languageStopwordMap.get(tokenizer.getLanguage());
                    String indexKeyName = Indexable.indexedWords.jsonName();
                    Iterator<String> wordIterator = tokenizer.getWords().iterator();
                    Node node = file.getNode();
                    TreeSet<String> indexedWords = new TreeSet<String>();
                    while (wordIterator.hasNext()) {
                        tx = StructrApp.getInstance().tx();
                        throwable = null;
                        try {
                            fulltextIndex.remove((Object)node, indexKeyName);
                            while (wordIterator.hasNext()) {
                                String word = StringUtils.strip((String)wordIterator.next(), (String)"\"");
                                if (stopWords.contains(word)) continue;
                                indexedWords.add(word);
                                fulltextIndex.add((Object)node, indexKeyName, (Object)word, String.class);
                            }
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                    tx = StructrApp.getInstance().tx();
                    throwable = null;
                    try {
                        file.getSecurityContext().preventModificationOfAccessTime();
                        file.setProperty((PropertyKey)Indexable.indexedWords, (Object)indexedWords.toArray(new String[indexedWords.size()]));
                        tx.success();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                    logger.info("Indexing of {} finished, {} words extracted", new Object[]{fileName, tokenizer.getWordCount()});
                }
                catch (Throwable throwable) {
                    var6_7 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable t) {
                logger.warn("Indexing of {} failed", (Object)fileName, (Object)t);
            }
        }
    }

    static {
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(FulltextIndexingAgent.class.getResourceAsStream("/stopwords/stop-words.zip")));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String entryName;
                if (!entry.isDirectory() && (entryName = entry.getName()).contains("_") && entryName.endsWith(".txt")) {
                    int langPos = entryName.lastIndexOf("_") + 1;
                    String language = entryName.substring(langPos, langPos + 2);
                    Set<String> stopwordSet = languageStopwordMap.get(language);
                    if (stopwordSet == null) {
                        stopwordSet = new LinkedHashSet<String>();
                        languageStopwordMap.put(language, stopwordSet);
                    }
                    for (String word : IOUtils.readLines((InputStream)zis)) {
                        stopwordSet.add(word.trim());
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }
}

