/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class LuceneLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    private static final String NAME = GraphDatabaseSettings.LabelIndex.LUCENE.name();

    public LuceneLabelScanStoreExtension() {
        super("lucene-scan-store");
    }

    public LabelScanStoreProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Config config = dependencies.getConfig();
        boolean ephemeral = (Boolean)config.get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        FileSystemAbstraction fileSystem = dependencies.fileSystem();
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(ephemeral, fileSystem);
        LuceneLabelScanIndexBuilder indexBuilder = this.getIndexBuilder(context, directoryFactory, fileSystem, config);
        LogProvider logger = dependencies.getLogService().getInternalLogProvider();
        Monitors monitors = dependencies.monitors();
        monitors.addMonitorListener((Object)new LoggingMonitor(logger.getLog(LuceneLabelScanStore.class)), new String[0]);
        LuceneLabelScanStore scanStore = new LuceneLabelScanStore(indexBuilder, (FullStoreChangeStream)new FullLabelStream(dependencies.indexStoreView()), (LabelScanStore.Monitor)monitors.newMonitor(LabelScanStore.Monitor.class, new String[0]));
        return new LabelScanStoreProvider(NAME, (LabelScanStore)scanStore);
    }

    private LuceneLabelScanIndexBuilder getIndexBuilder(KernelContext context, DirectoryFactory directoryFactory, FileSystemAbstraction fileSystem, Config config) {
        return (LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withDirectoryFactory(directoryFactory)).withFileSystem(fileSystem)).withIndexRootFolder(LabelScanStoreProvider.getStoreDirectory((File)context.storeDir()))).withConfig(config);
    }

    public static interface Dependencies {
        public Config getConfig();

        public Supplier<IndexStoreView> indexStoreView();

        public LogService getLogService();

        public FileSystemAbstraction fileSystem();

        public Monitors monitors();
    }
}

