/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.NativeResult;
import org.structr.api.NotInTransactionException;
import org.structr.api.Transaction;
import org.structr.api.config.Settings;
import org.structr.api.graph.GraphProperties;
import org.structr.api.graph.Label;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.index.Index;
import org.structr.api.util.Iterables;
import org.structr.bolt.SessionTransaction;
import org.structr.bolt.index.CypherNodeIndex;
import org.structr.bolt.index.CypherRelationshipIndex;
import org.structr.bolt.mapper.NodeNodeMapper;
import org.structr.bolt.mapper.RelationshipRelationshipMapper;
import org.structr.bolt.wrapper.NodeWrapper;
import org.structr.bolt.wrapper.RelationshipWrapper;

public class BoltDatabaseService
implements DatabaseService,
GraphProperties {
    private static final Logger logger = LoggerFactory.getLogger((String)BoltDatabaseService.class.getName());
    private static final Map<String, RelationshipType> relTypeCache = new ConcurrentHashMap<String, RelationshipType>();
    private static final Map<String, Label> labelCache = new ConcurrentHashMap<String, Label>();
    private static final ThreadLocal<SessionTransaction> sessions = new ThreadLocal();
    private Properties globalGraphProperties = null;
    private CypherRelationshipIndex relationshipIndex = null;
    private CypherNodeIndex nodeIndex = null;
    private GraphDatabaseService graphDb = null;
    private boolean needsIndexRebuild = false;
    private String databaseUrl = null;
    private String databasePath = null;
    private Driver driver = null;
    private int queryCacheSize = 1000;

    public void initialize() {
        String databaseDriverUrl;
        String databaseServerUrl;
        this.databasePath = (String)Settings.DatabasePath.getValue();
        GraphDatabaseSettings.BoltConnector bolt = GraphDatabaseSettings.boltConnector((String)"0");
        this.databaseUrl = (String)Settings.ConnectionUrl.getValue();
        String username = (String)Settings.ConnectionUser.getValue();
        String password = (String)Settings.ConnectionPassword.getValue();
        String driverMode = (String)Settings.DatabaseDriverMode.getValue();
        String confPath = this.databasePath + "/neo4j.conf";
        File confFile = new File(confPath);
        boolean tryAgain = true;
        if (this.databaseUrl.length() >= 7 && this.databaseUrl.substring(0, 7).equalsIgnoreCase("bolt://")) {
            databaseServerUrl = this.databaseUrl.substring(7);
            databaseDriverUrl = this.databaseUrl;
        } else {
            databaseServerUrl = this.databaseUrl;
            databaseDriverUrl = "bolt://" + this.databaseUrl;
        }
        new File(this.databasePath).mkdirs();
        if (!"remote".equals(driverMode)) {
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(new File(this.databasePath)).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").setConfig("dbms.allow_format_migration", "true").setConfig(bolt.type, "BOLT").setConfig(bolt.enabled, "true").setConfig(bolt.address, databaseServerUrl);
            if (confFile.exists()) {
                builder.loadPropertiesFromFile(confPath);
            }
            while (tryAgain) {
                try {
                    this.graphDb = builder.newGraphDatabase();
                    tryAgain = false;
                }
                catch (Throwable t) {
                    tryAgain = this.handleMigration(t);
                }
            }
        }
        this.driver = GraphDatabase.driver((String)databaseDriverUrl, (AuthToken)AuthTokens.basic((String)username, (String)password), (Config)Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig());
        int relCacheSize = (Integer)Settings.RelationshipCacheSize.getValue();
        int nodeCacheSize = (Integer)Settings.NodeCacheSize.getValue();
        this.queryCacheSize = (Integer)Settings.QueryCacheSize.getValue();
        NodeWrapper.initialize(nodeCacheSize);
        logger.info("Node cache size set to {}", (Object)nodeCacheSize);
        RelationshipWrapper.initialize(relCacheSize);
        logger.info("Relationship cache size set to {}", (Object)relCacheSize);
    }

    public void shutdown() {
        RelationshipWrapper.clearCache();
        NodeWrapper.clearCache();
        this.driver.close();
        this.graphDb.shutdown();
    }

    public <T> T forName(Class<T> type, String name) {
        if (Label.class.equals(type)) {
            return (T)this.getOrCreateLabel(name);
        }
        if (RelationshipType.class.equals(type)) {
            return (T)this.getOrCreateRelationshipType(name);
        }
        throw new RuntimeException("Cannot create object of type " + type);
    }

    public Transaction beginTx() {
        SessionTransaction session = sessions.get();
        if (session == null || session.isClosed()) {
            try {
                session = new SessionTransaction(this, this.driver.session());
                sessions.set(session);
            }
            catch (ClientException cex) {
                logger.warn("Cannot connect to Neo4j database server at {}", (Object)this.databaseUrl);
            }
        }
        return session;
    }

    public Node createNode(Set<String> labels, Map<String, Object> properties) {
        StringBuilder buf = new StringBuilder("CREATE (n");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String label : labels) {
            buf.append(":");
            buf.append(label);
        }
        buf.append(" {properties}) RETURN n");
        map.put("properties", properties);
        return NodeWrapper.newInstance(this, this.getCurrentTransaction().getNode(buf.toString(), map));
    }

    public Node getNodeById(long id) {
        return NodeWrapper.newInstance(this, id);
    }

    public Relationship getRelationshipById(long id) {
        SessionTransaction tx = this.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        org.neo4j.driver.v1.types.Relationship rel = tx.getRelationship("MATCH ()-[r]->() WHERE ID(r) = {id} RETURN r", map);
        return RelationshipWrapper.newInstance(this, rel);
    }

    public Iterable<Node> getAllNodes() {
        SessionTransaction tx = this.getCurrentTransaction();
        NodeNodeMapper mapper = new NodeNodeMapper(this);
        return Iterables.map((Function)mapper, tx.getNodes("MATCH (n) RETURN n", Collections.emptyMap()));
    }

    public Iterable<Node> getNodesByLabel(String type) {
        if (type == null) {
            return this.getAllNodes();
        }
        SessionTransaction tx = this.getCurrentTransaction();
        NodeNodeMapper mapper = new NodeNodeMapper(this);
        return Iterables.map((Function)mapper, tx.getNodes("MATCH (n:" + type + ") RETURN n", Collections.emptyMap()));
    }

    public Iterable<Node> getNodesByTypeProperty(String type) {
        if (type == null) {
            return this.getAllNodes();
        }
        SessionTransaction tx = this.getCurrentTransaction();
        NodeNodeMapper mapper = new NodeNodeMapper(this);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", type);
        return Iterables.map((Function)mapper, tx.getNodes("MATCH (n) WHERE n.type = {type} RETURN n", map));
    }

    public Iterable<Relationship> getAllRelationships() {
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this);
        SessionTransaction tx = this.getCurrentTransaction();
        return Iterables.map((Function)mapper, tx.getRelationships("MATCH ()-[r]->() RETURN r", Collections.emptyMap()));
    }

    public Iterable<Relationship> getRelationshipsByType(String type) {
        if (type == null) {
            return this.getAllRelationships();
        }
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this);
        SessionTransaction tx = this.getCurrentTransaction();
        return Iterables.map((Function)mapper, tx.getRelationships("MATCH ()-[r:" + type + "]->() RETURN r", Collections.emptyMap()));
    }

    public GraphProperties getGlobalProperties() {
        return this;
    }

    public Index<Node> nodeIndex() {
        if (this.nodeIndex == null) {
            this.nodeIndex = new CypherNodeIndex(this, this.queryCacheSize);
        }
        return this.nodeIndex;
    }

    public Index<Relationship> relationshipIndex() {
        if (this.relationshipIndex == null) {
            this.relationshipIndex = new CypherRelationshipIndex(this, this.queryCacheSize);
        }
        return this.relationshipIndex;
    }

    public NativeResult execute(String nativeQuery, Map<String, Object> parameters) {
        return this.getCurrentTransaction().run(nativeQuery, parameters);
    }

    public NativeResult execute(String nativeQuery) {
        return this.execute(nativeQuery, Collections.EMPTY_MAP);
    }

    public void invalidateQueryCache() {
        if (this.nodeIndex != null) {
            this.nodeIndex.invalidateCache();
        }
        if (this.relationshipIndex != null) {
            this.relationshipIndex.invalidateCache();
        }
    }

    public SessionTransaction getCurrentTransaction() {
        SessionTransaction tx = sessions.get();
        if (tx == null || tx.isClosed()) {
            throw new NotInTransactionException("Not in transaction");
        }
        return tx;
    }

    public boolean logQueries() {
        return (Boolean)Settings.CypherDebugLogging.getValue();
    }

    public void setProperty(String name, Object value) {
        Properties properties = this.getProperties();
        boolean hasChanges = false;
        if (value == null) {
            if (properties.containsKey(name)) {
                properties.remove(name);
                hasChanges = true;
            }
        } else {
            properties.setProperty(name, value.toString());
            hasChanges = true;
        }
        if (hasChanges) {
            File propertiesFile = new File(this.databasePath + "/graph.properties");
            try (FileWriter writer = new FileWriter(propertiesFile);){
                properties.store(writer, "Created by Structr at " + new Date());
            }
            catch (IOException ioex) {
                logger.warn("Unable to write properties file", (Throwable)ioex);
            }
        }
    }

    public Object getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public boolean needsIndexRebuild() {
        return this.needsIndexRebuild;
    }

    public Label getOrCreateLabel(String name) {
        Label label = labelCache.get(name);
        if (label == null) {
            label = new LabelImpl(name);
            labelCache.put(name, label);
        }
        return label;
    }

    public RelationshipType getOrCreateRelationshipType(String name) {
        RelationshipType relType = relTypeCache.get(name);
        if (relType == null) {
            relType = new RelationshipTypeImpl(name);
            relTypeCache.put(name, relType);
        }
        return relType;
    }

    private Properties getProperties() {
        if (this.globalGraphProperties == null) {
            this.globalGraphProperties = new Properties();
            File propertiesFile = new File(this.databasePath + "/graph.properties");
            try (FileReader reader = new FileReader(propertiesFile);){
                this.globalGraphProperties.load(reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.globalGraphProperties;
    }

    private boolean handleMigration(Throwable t) {
        List<String> messages = this.collectMessages(t);
        if (this.contains(messages, "Legacy index migration failed")) {
            logger.info("Legacy index migration failed, moving offending index files out of the way.");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            File indexDbFile = new File(this.databasePath + "/index.db");
            File indexDir = new File(this.databasePath + "/index");
            if (indexDbFile.exists()) {
                indexDbFile.renameTo(new File(this.databasePath + "/index.db.orig-" + df.format(System.currentTimeMillis())));
            }
            if (indexDir.exists()) {
                indexDir.renameTo(new File(this.databasePath + "/index.orig-" + df.format(System.currentTimeMillis())));
            }
            this.needsIndexRebuild = true;
            return true;
        }
        throw new RuntimeException(t);
    }

    private boolean contains(List<String> src, String toFind) {
        for (String s : src) {
            if (!s.contains(toFind)) continue;
            return true;
        }
        return false;
    }

    private List<String> collectMessages(Throwable t) {
        LinkedList<String> messages = new LinkedList<String>();
        for (Throwable current = t; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    private static class RelationshipTypeImpl
    implements RelationshipType {
        private String name = null;

        private RelationshipTypeImpl(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof RelationshipType) {
                return other.hashCode() == this.hashCode();
            }
            return false;
        }
    }

    private static class LabelImpl
    implements Label {
        private String name = null;

        private LabelImpl(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Label) {
                return other.hashCode() == this.hashCode();
            }
            return false;
        }
    }
}

