/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;
import org.structr.api.NativeResult;
import org.structr.api.NotFoundException;
import org.structr.api.RetryException;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.mapper.RecordLongMapper;
import org.structr.bolt.mapper.RecordNodeMapper;
import org.structr.bolt.mapper.RecordRelationshipMapper;
import org.structr.bolt.wrapper.EntityWrapper;
import org.structr.bolt.wrapper.StatementResultWrapper;

public class SessionTransaction
implements org.structr.api.Transaction {
    private final Set<EntityWrapper> modifiedEntities = new HashSet<EntityWrapper>();
    private BoltDatabaseService db = null;
    private Session session = null;
    private Transaction tx = null;
    private boolean closed = false;
    private boolean success = false;

    public SessionTransaction(BoltDatabaseService db, Session session) {
        this.session = session;
        this.tx = session.beginTransaction();
        this.db = db;
    }

    public void failure() {
        this.tx.failure();
    }

    public void success() {
        this.tx.success();
        this.success = true;
    }

    public void close() {
        if (!this.success) {
            for (EntityWrapper entity : this.modifiedEntities) {
                entity.stale();
            }
        } else {
            if (!this.modifiedEntities.isEmpty()) {
                this.db.invalidateQueryCache();
            }
            for (EntityWrapper entity : this.modifiedEntities) {
                entity.clearCaches();
            }
        }
        this.closed = true;
        try {
            this.tx.close();
            this.session.close();
        }
        catch (TransientException tex) {
            throw new RetryException((Throwable)tex);
        }
        finally {
            if (this.session.isOpen()) {
                this.session.close();
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public long getLong(String statement) {
        try {
            if (this.db.logQueries()) {
                System.out.println(statement);
            }
            return this.getLong(statement, Collections.EMPTY_MAP);
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public long getLong(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return this.tx.run(statement, map).next().get(0).asLong();
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Object getObject(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            StatementResult result = this.tx.run(statement, map);
            if (result.hasNext()) {
                return result.next().get(0).asObject();
            }
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
        return null;
    }

    public Entity getEntity(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return this.tx.run(statement, map).next().get(0).asEntity();
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Node getNode(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return this.tx.run(statement, map).next().get(0).asNode();
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Relationship getRelationship(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return this.tx.run(statement, map).next().get(0).asRelationship();
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Iterable<Node> getNodes(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return Iterables.map((Function)new RecordNodeMapper(), (Iterable)new StatementIterable(this.tx.run(statement, map)));
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Iterable<Relationship> getRelationships(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return Iterables.map((Function)new RecordRelationshipMapper(), (Iterable)new StatementIterable(this.tx.run(statement, map)));
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Iterable<Long> getIds(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return Iterables.map((Function)new RecordLongMapper(), (Iterable)new StatementIterable(this.tx.run(statement, map)));
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public Iterable<String> getStrings(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            StatementResult result = this.tx.run(statement, map);
            Record record = result.next();
            Value value = record.get(0);
            return value.asList(Values.ofString());
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public NativeResult run(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            return new StatementResultWrapper(this.db, this.tx.run(statement, map));
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public void set(String statement, Map<String, Object> map) {
        try {
            this.logQuery(statement, map);
            this.tx.run(statement, map).consume();
        }
        catch (TransientException tex) {
            this.closed = true;
            throw new RetryException((Throwable)tex);
        }
        catch (NoSuchRecordException nex) {
            throw new NotFoundException((Throwable)nex);
        }
    }

    public void logQuery(String statement) {
        this.logQuery(statement, null);
    }

    public void logQuery(String statement, Map<String, Object> map) {
        if (this.db.logQueries()) {
            if (map != null && map.size() > 0) {
                System.out.println(statement + "\t\t Parameters: " + map.toString());
            } else {
                System.out.println(statement);
            }
        }
    }

    public void modified(EntityWrapper wrapper) {
        this.db.invalidateQueryCache();
        this.modifiedEntities.add(wrapper);
    }

    private class StatementIterable
    implements Iterable<Record> {
        private StatementResult result = null;

        public StatementIterable(StatementResult result) {
            this.result = result;
        }

        @Override
        public Iterator<Record> iterator() {
            return new Iterator<Record>(){

                @Override
                public boolean hasNext() {
                    return StatementIterable.this.result.hasNext();
                }

                @Override
                public Record next() {
                    try {
                        return StatementIterable.this.result.next();
                    }
                    catch (TransientException tex) {
                        SessionTransaction.this.closed = true;
                        throw new RetryException((Throwable)tex);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Removal not supported.");
                }
            };
        }
    }
}

