/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.QueryResult;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.index.Index;
import org.structr.api.search.ArrayQuery;
import org.structr.api.search.EmptyQuery;
import org.structr.api.search.ExactQuery;
import org.structr.api.search.FulltextQuery;
import org.structr.api.search.GroupQuery;
import org.structr.api.search.NotEmptyQuery;
import org.structr.api.search.QueryPredicate;
import org.structr.api.search.RangeQuery;
import org.structr.api.search.SpatialQuery;
import org.structr.api.search.TypeConverter;
import org.structr.api.search.TypeQuery;
import org.structr.api.search.UuidQuery;
import org.structr.api.util.FixedSizeCache;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.index.converter.BooleanTypeConverter;
import org.structr.bolt.index.converter.DateTypeConverter;
import org.structr.bolt.index.converter.DoubleTypeConverter;
import org.structr.bolt.index.converter.IntTypeConverter;
import org.structr.bolt.index.converter.LongTypeConverter;
import org.structr.bolt.index.converter.StringTypeConverter;
import org.structr.bolt.index.factory.ArrayQueryFactory;
import org.structr.bolt.index.factory.EmptyQueryFactory;
import org.structr.bolt.index.factory.GroupQueryFactory;
import org.structr.bolt.index.factory.KeywordQueryFactory;
import org.structr.bolt.index.factory.NotEmptyQueryFactory;
import org.structr.bolt.index.factory.QueryFactory;
import org.structr.bolt.index.factory.RangeQueryFactory;
import org.structr.bolt.index.factory.SpatialQueryFactory;
import org.structr.bolt.index.factory.TypeQueryFactory;
import org.structr.bolt.index.factory.UuidQueryFactory;

public abstract class AbstractCypherIndex<T extends PropertyContainer>
implements Index<T>,
QueryFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractCypherIndex.class.getName());
    public static final TypeConverter DEFAULT_CONVERTER = new StringTypeConverter();
    public static final Map<Class, TypeConverter> CONVERTERS = new HashMap<Class, TypeConverter>();
    public static final Map<Class, QueryFactory> FACTORIES = new HashMap<Class, QueryFactory>();
    public static final Set<Class> INDEXABLE = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Double.class, Integer.class, Long.class, Character.class, Float.class));
    protected final FixedSizeCache<Integer, CachedQueryResult> queryCache;
    protected final BoltDatabaseService db;

    public AbstractCypherIndex(BoltDatabaseService db, int queryCacheSize) {
        this.queryCache = new FixedSizeCache(queryCacheSize);
        this.db = db;
    }

    public abstract QueryResult<T> getResult(CypherQuery var1);

    public abstract String getQueryPrefix(String var1, String var2, String var3);

    public abstract String getQuerySuffix();

    public void add(PropertyContainer t, String key, Object value, Class typeHint) {
        Object indexValue = value;
        if (value != null) {
            Class<?> type = value.getClass();
            if (type.isEnum()) {
                indexValue = indexValue.toString();
            }
            if (!INDEXABLE.contains(type)) {
                return;
            }
        }
        t.setProperty(key, indexValue);
    }

    public void remove(PropertyContainer t) {
    }

    public void remove(PropertyContainer t, String key) {
    }

    public Iterable<T> query(QueryPredicate predicate) {
        CypherQuery query = new CypherQuery(this);
        this.createQuery(this, predicate, query, true);
        String sortKey = predicate.getSortKey();
        if (sortKey != null) {
            query.sort(predicate.getSortType(), sortKey, predicate.sortDescending());
        }
        return this.getResult(query);
    }

    public void invalidateCache() {
        if (!this.queryCache.isEmpty()) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean createQuery(QueryFactory parent, QueryPredicate predicate, CypherQuery query, boolean isFirst) {
        Class type = predicate.getQueryType();
        if (type != null) {
            QueryFactory factory = FACTORIES.get(type);
            if (factory != null) {
                return factory.createQuery(this, predicate, query, isFirst);
            }
            logger.warn("No query factory registered for type {}", (Object)type);
        }
        return false;
    }

    static {
        FACTORIES.put(NotEmptyQuery.class, new NotEmptyQueryFactory());
        FACTORIES.put(FulltextQuery.class, new KeywordQueryFactory());
        FACTORIES.put(SpatialQuery.class, new SpatialQueryFactory());
        FACTORIES.put(GroupQuery.class, new GroupQueryFactory());
        FACTORIES.put(RangeQuery.class, new RangeQueryFactory());
        FACTORIES.put(ExactQuery.class, new KeywordQueryFactory());
        FACTORIES.put(ArrayQuery.class, new ArrayQueryFactory());
        FACTORIES.put(EmptyQuery.class, new EmptyQueryFactory());
        FACTORIES.put(TypeQuery.class, new TypeQueryFactory());
        FACTORIES.put(UuidQuery.class, new UuidQueryFactory());
        CONVERTERS.put(Boolean.class, new BooleanTypeConverter());
        CONVERTERS.put(String.class, new StringTypeConverter());
        CONVERTERS.put(Date.class, new DateTypeConverter());
        CONVERTERS.put(Long.class, new LongTypeConverter());
        CONVERTERS.put(Integer.class, new IntTypeConverter());
        CONVERTERS.put(Double.class, new DoubleTypeConverter());
    }

    protected class CachedQueryResult
    implements QueryResult<T> {
        private Collection<T> result = null;

        public CachedQueryResult(Iterable<T> source) {
            this.result = source instanceof Collection ? (Collection)source : Iterables.toList(source);
        }

        public void close() {
        }

        public Iterator<T> iterator() {
            return this.result.iterator();
        }

        public boolean isEmpty() {
            return this.result.isEmpty();
        }
    }
}

