/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index;

import java.util.function.Function;
import org.structr.api.QueryResult;
import org.structr.api.graph.Node;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.SessionTransaction;
import org.structr.bolt.index.AbstractCypherIndex;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.mapper.NodeNodeMapper;

public class CypherNodeIndex
extends AbstractCypherIndex<Node> {
    public CypherNodeIndex(BoltDatabaseService db, int queryCacheSize) {
        super(db, queryCacheSize);
    }

    @Override
    public String getQueryPrefix(String typeLabel, String sourceTypeLabel, String targetTypeLabel) {
        if (typeLabel != null) {
            return "MATCH (n:" + typeLabel + ")";
        }
        return "MATCH (n:NodeInterface)";
    }

    @Override
    public String getQuerySuffix() {
        return " RETURN DISTINCT n";
    }

    @Override
    public QueryResult<Node> getResult(CypherQuery query) {
        SessionTransaction tx;
        NodeNodeMapper mapper;
        Iterable mapped;
        int queryHashCode = query.getHashCode();
        AbstractCypherIndex.CachedQueryResult result = (AbstractCypherIndex.CachedQueryResult)this.queryCache.get((Object)queryHashCode);
        if (result == null && !(result = new AbstractCypherIndex.CachedQueryResult(this, mapped = Iterables.map((Function)(mapper = new NodeNodeMapper(this.db)), (tx = this.db.getCurrentTransaction()).getNodes(query.getStatement(), query.getParameters())))).isEmpty()) {
            this.queryCache.put((Object)queryHashCode, (Object)result);
        }
        return result;
    }
}

