/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.structr.api.search.SortType;
import org.structr.bolt.index.AbstractCypherIndex;

public class CypherQuery {
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final List<String> typeLabels = new LinkedList<String>();
    private final StringBuilder buffer = new StringBuilder();
    private String sourceTypeLabel = null;
    private String targetTypeLabel = null;
    private AbstractCypherIndex<?> index = null;
    private boolean sortDescending = false;
    private SortType sortType = null;
    private String sortKey = null;
    private int count = 0;

    public CypherQuery(AbstractCypherIndex<?> index) {
        this.index = index;
    }

    public String toString() {
        return this.getStatement();
    }

    public int getHashCode() {
        int hashCode = 23;
        hashCode += 27 * this.typeLabels.hashCode();
        hashCode += 37 * this.getStatement().hashCode();
        hashCode += 47 * this.deepHashCode(this.parameters);
        hashCode += 57 * this.sortKey.hashCode();
        if (this.sortDescending) {
            ++hashCode;
        }
        return hashCode;
    }

    public String getStatement() {
        StringBuilder buf = new StringBuilder();
        int typeCount = this.typeLabels.size();
        switch (typeCount) {
            case 0: {
                buf.append(this.index.getQueryPrefix(null, this.sourceTypeLabel, this.targetTypeLabel));
                if (this.buffer.length() > 0) {
                    buf.append(" WHERE ");
                    buf.append((CharSequence)this.buffer);
                }
                buf.append(this.index.getQuerySuffix());
                break;
            }
            case 1: {
                buf.append(this.index.getQueryPrefix(this.typeLabels.get(0), this.sourceTypeLabel, this.targetTypeLabel));
                if (this.buffer.length() > 0) {
                    buf.append(" WHERE ");
                    buf.append((CharSequence)this.buffer);
                }
                buf.append(this.index.getQuerySuffix());
                break;
            }
            default: {
                Iterator<String> it = this.typeLabels.iterator();
                while (it.hasNext()) {
                    buf.append(this.index.getQueryPrefix(it.next(), this.sourceTypeLabel, this.targetTypeLabel));
                    if (this.buffer.length() > 0) {
                        buf.append(" WHERE ");
                        buf.append((CharSequence)this.buffer);
                    }
                    buf.append(this.index.getQuerySuffix());
                    if (!it.hasNext()) continue;
                    buf.append(" UNION ");
                }
                break block0;
            }
        }
        if (this.sortKey != null) {
            buf.append(" ORDER BY COALESCE(n.`");
            buf.append(this.sortKey);
            buf.append("`, ");
            switch (this.sortType) {
                case Default: {
                    buf.append("''");
                    break;
                }
                default: {
                    buf.append("-1");
                }
            }
            buf.append(")");
            if (this.sortDescending) {
                buf.append(" DESC");
            }
        }
        return buf.toString();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void beginGroup() {
        this.buffer.append("(");
    }

    public void endGroup() {
        this.buffer.append(")");
    }

    public void and() {
        this.buffer.append(" AND ");
    }

    public void not() {
        this.buffer.append(" NOT ");
    }

    public void andNot() {
        this.buffer.append(" AND NOT ");
    }

    public void or() {
        this.buffer.append(" OR ");
    }

    public void noop() {
        this.buffer.append(" True ");
    }

    public void typeLabel(String typeLabel) {
        this.typeLabels.add(typeLabel);
    }

    public void addSimpleParameter(String key, String operator, Object value) {
        this.addSimpleParameter(key, operator, value, true);
    }

    public void addSimpleParameter(String key, String operator, Object value, boolean isProperty) {
        if (value != null) {
            String paramKey = "param" + this.count++;
            if (isProperty) {
                this.buffer.append("n.`");
            }
            this.buffer.append(key);
            if (isProperty) {
                this.buffer.append("` ");
            } else {
                this.buffer.append(" ");
            }
            this.buffer.append(operator);
            this.buffer.append(" {");
            this.buffer.append(paramKey);
            this.buffer.append("}");
            this.parameters.put(paramKey, value);
        } else {
            if (isProperty) {
                this.buffer.append("n.`");
            }
            this.buffer.append(key);
            if (isProperty) {
                this.buffer.append("` ");
            }
            this.buffer.append(operator);
            this.buffer.append(" Null");
        }
    }

    public void addListParameter(String key, String operator, Object value) {
        if (value != null) {
            String paramKey = "param" + this.count++;
            this.buffer.append("ANY(x IN n.`");
            this.buffer.append(key);
            this.buffer.append("` WHERE x ");
            this.buffer.append(operator);
            this.buffer.append(" {");
            this.buffer.append(paramKey);
            this.buffer.append("})");
            this.parameters.put(paramKey, value);
        } else {
            this.buffer.append("ANY(x IN n.`");
            this.buffer.append(key);
            this.buffer.append("` WHERE x ");
            this.buffer.append(operator);
            this.buffer.append(" Null)");
        }
    }

    public void addParameters(String key, String operator1, Object value1, String operator2, Object value2) {
        String paramKey1 = "param" + this.count++;
        String paramKey2 = "param" + this.count++;
        this.buffer.append("(n.`");
        this.buffer.append(key);
        this.buffer.append("` ");
        this.buffer.append(operator1);
        this.buffer.append(" {");
        this.buffer.append(paramKey1);
        this.buffer.append("}");
        this.buffer.append(" AND ");
        this.buffer.append("n.`");
        this.buffer.append(key);
        this.buffer.append("` ");
        this.buffer.append(operator2);
        this.buffer.append(" {");
        this.buffer.append(paramKey2);
        this.buffer.append("})");
        this.parameters.put(paramKey1, value1);
        this.parameters.put(paramKey2, value2);
    }

    public void sort(SortType sortType, String sortKey, boolean sortDescending) {
        this.sortDescending = sortDescending;
        this.sortType = sortType;
        this.sortKey = sortKey;
    }

    public void setSourceType(String sourceTypeLabel) {
        this.sourceTypeLabel = sourceTypeLabel;
    }

    public void setTargetType(String targetTypeLabel) {
        this.targetTypeLabel = targetTypeLabel;
    }

    private int deepHashCode(Map<String, Object> map) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            buf.append("|");
            buf.append(entry.getKey());
            buf.append("|");
            buf.append(entry.getValue());
        }
        return buf.toString().hashCode();
    }
}

